/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.simplehistory.impl.ClassificationHistoryQueryImpl;
import pro.taskana.simplehistory.impl.TaskHistoryQueryImpl;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.simplehistory.impl.WorkbasketHistoryQueryImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryEventMapper;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery;
import pro.taskana.simplehistory.impl.task.TaskHistoryEventMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryEventMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

public class SimpleHistoryServiceImpl
implements TaskanaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHistoryServiceImpl.class);
    private TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private TaskHistoryEventMapper taskHistoryEventMapper;
    private WorkbasketHistoryEventMapper workbasketHistoryEventMapper;
    private ClassificationHistoryEventMapper classificationHistoryEventMapper;

    public void initialize(TaskanaEngine taskanaEngine) {
        this.taskanaHistoryEngine = this.getTaskanaEngine(taskanaEngine);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Simple history service implementation initialized with schemaName: {} ", (Object)taskanaEngine.getConfiguration().getSchemaName());
        }
        this.taskHistoryEventMapper = (TaskHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(TaskHistoryEventMapper.class);
        this.workbasketHistoryEventMapper = (WorkbasketHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(WorkbasketHistoryEventMapper.class);
        this.classificationHistoryEventMapper = (ClassificationHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(ClassificationHistoryEventMapper.class);
    }

    public void create(TaskHistoryEvent event) {
        try {
            this.taskanaHistoryEngine.openConnection();
            if (event.getCreated() == null) {
                Instant now = Instant.now();
                event.setCreated(now);
            }
            this.taskHistoryEventMapper.insert(event);
        }
        catch (SQLException e) {
            LOGGER.error("Error while inserting task history event into database", (Throwable)e);
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("Exit from create(TaskHistoryEvent event). Returning object = {}.", (Object)event);
        }
    }

    public void create(WorkbasketHistoryEvent event) {
        try {
            this.taskanaHistoryEngine.openConnection();
            if (event.getCreated() == null) {
                Instant now = Instant.now();
                event.setCreated(now);
            }
            this.workbasketHistoryEventMapper.insert(event);
        }
        catch (SQLException e) {
            LOGGER.error("Error while inserting workbasket history event into database", (Throwable)e);
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("Exit from create(WorkbasketHistoryEvent event). Returning object = {}.", (Object)event);
        }
    }

    public void create(ClassificationHistoryEvent event) {
        try {
            this.taskanaHistoryEngine.openConnection();
            if (event.getCreated() == null) {
                Instant now = Instant.now();
                event.setCreated(now);
            }
            this.classificationHistoryEventMapper.insert(event);
        }
        catch (SQLException e) {
            LOGGER.error("Error while inserting classification history event into database", (Throwable)e);
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("Exit from create(ClassificationHistoryEvent event). Returning object = {}.", (Object)event);
        }
    }

    public void deleteHistoryEventsByTaskIds(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteHistoryEventsByTaskIds(taskIds = {})", taskIds);
        }
        this.taskanaHistoryEngine.checkRoleMembership(TaskanaRole.ADMIN);
        if (taskIds == null) {
            throw new InvalidArgumentException("List of taskIds must not be null.");
        }
        try {
            this.taskanaHistoryEngine.openConnection();
            this.taskHistoryEventMapper.deleteMultipleByTaskIds(taskIds);
        }
        catch (SQLException e) {
            LOGGER.error("Caught exception while trying to delete history events", (Throwable)e);
        }
        finally {
            LOGGER.debug("exit from deleteHistoryEventsByTaskIds()");
            this.taskanaHistoryEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskHistoryEvent getTaskHistoryEvent(String historyEventId) throws TaskanaHistoryEventNotFoundException {
        LOGGER.debug("entry to getTaskHistoryEvent (id = {})", (Object)historyEventId);
        TaskHistoryEvent resultEvent = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            resultEvent = this.taskHistoryEventMapper.findById(historyEventId);
            if (resultEvent == null) {
                throw new TaskanaHistoryEventNotFoundException(historyEventId, String.format("TaskHistoryEvent for id %s was not found", historyEventId));
            }
            TaskHistoryEvent taskHistoryEvent = resultEvent;
            return taskHistoryEvent;
        }
        catch (SQLException e) {
            LOGGER.error("Caught exception while trying to retrieve a history event", (Throwable)e);
            TaskHistoryEvent taskHistoryEvent = resultEvent;
            return taskHistoryEvent;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("exit from getHistoryEvent(). Returning result {} ", (Object)resultEvent);
        }
    }

    public TaskHistoryQuery createTaskHistoryQuery() {
        return new TaskHistoryQueryImpl(this.taskanaHistoryEngine);
    }

    public WorkbasketHistoryQuery createWorkbasketHistoryQuery() {
        return new WorkbasketHistoryQueryImpl(this.taskanaHistoryEngine);
    }

    public ClassificationHistoryQuery createClassificationHistoryQuery() {
        return new ClassificationHistoryQueryImpl(this.taskanaHistoryEngine);
    }

    TaskanaHistoryEngineImpl getTaskanaEngine(TaskanaEngine taskanaEngine) {
        return TaskanaHistoryEngineImpl.createTaskanaEngine(taskanaEngine);
    }
}

