/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryColumnName;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;
import pro.taskana.workbasket.api.WorkbasketCustomField;

public class WorkbasketHistoryQueryImpl
implements WorkbasketHistoryQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper.queryHistoryEvents";
    private static final String LINK_TO_VALUE_MAPPER = "pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper.queryHistoryColumnValues";
    private static final String LINK_TO_COUNTER = "pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper.countHistoryEvents";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketHistoryQueryImpl.class);
    private static final String SQL_EXCEPTION_MESSAGE = "Method openConnection() could not open a connection to the database.";
    private TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private WorkbasketHistoryQueryColumnName columnName;
    private List<String> orderBy;
    private List<String> orderColumns;
    private String[] idIn;
    private String[] workbasketIdIn;
    private String[] eventTypeIn;
    private TimeInterval[] createdIn;
    private String[] userIdIn;
    private String[] domainIn;
    private String[] keyIn;
    private String[] typeIn;
    private String[] ownerIn;
    private String[] custom1In;
    private String[] custom2In;
    private String[] custom3In;
    private String[] custom4In;
    private String[] orgLevel1In;
    private String[] orgLevel2In;
    private String[] orgLevel3In;
    private String[] orgLevel4In;
    private String[] workbasketIdLike;
    private String[] eventTypeLike;
    private String[] userIdLike;
    private String[] domainLike;
    private String[] keyLike;
    private String[] typeLike;
    private String[] ownerLike;
    private String[] custom1Like;
    private String[] custom2Like;
    private String[] custom3Like;
    private String[] custom4Like;
    private String[] orgLevel1Like;
    private String[] orgLevel2Like;
    private String[] orgLevel3Like;
    private String[] orgLevel4Like;

    public WorkbasketHistoryQueryImpl(TaskanaHistoryEngineImpl internalTaskanaHistoryEngine) {
        this.taskanaHistoryEngine = internalTaskanaHistoryEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public String[] getEventTypeIn() {
        return this.eventTypeIn;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public String[] getUserIdIn() {
        return this.userIdIn;
    }

    public String[] getDomainIn() {
        return this.domainIn;
    }

    public String[] getKeyIn() {
        return this.keyIn;
    }

    public String[] getTypeIn() {
        return this.typeIn;
    }

    public String[] getOwnerIn() {
        return this.ownerIn;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getOrgLevel1In() {
        return this.orgLevel1In;
    }

    public String[] getOrgLevel2In() {
        return this.orgLevel2In;
    }

    public String[] getOrgLevel3In() {
        return this.orgLevel3In;
    }

    public String[] getOrgLevel4In() {
        return this.orgLevel4In;
    }

    public String[] getWorkbasketIdLike() {
        return this.workbasketIdLike;
    }

    public String[] getEventTypeLike() {
        return this.eventTypeLike;
    }

    public String[] getUserIdLike() {
        return this.userIdLike;
    }

    public String[] getDomainLike() {
        return this.domainLike;
    }

    public String[] getKeyLike() {
        return this.keyLike;
    }

    public String[] getTypeLike() {
        return this.typeLike;
    }

    public String[] getOwnerLike() {
        return this.ownerLike;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getOrgLevel1Like() {
        return this.orgLevel1Like;
    }

    public String[] getOrgLevel2Like() {
        return this.orgLevel2Like;
    }

    public String[] getOrgLevel3Like() {
        return this.orgLevel3Like;
    }

    public String[] getOrgLevel4Like() {
        return this.orgLevel4Like;
    }

    @Override
    public WorkbasketHistoryQuery idIn(String ... idIn) {
        this.idIn = this.toUpperCopy(idIn);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery workbasketIdIn(String ... workbasketId) {
        this.workbasketIdIn = this.toUpperCopy(workbasketId);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery eventTypeIn(String ... eventType) {
        this.eventTypeIn = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery createdWithin(TimeInterval ... createdIn) {
        this.createdIn = createdIn;
        return this;
    }

    @Override
    public WorkbasketHistoryQuery userIdIn(String ... userId) {
        this.userIdIn = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery domainIn(String ... domain) {
        this.domainIn = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery keyIn(String ... workbasketKey) {
        this.keyIn = this.toUpperCopy(workbasketKey);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery typeIn(String ... workbasketType) {
        this.typeIn = this.toUpperCopy(workbasketType);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery ownerIn(String ... oownerIn) {
        this.ownerIn = this.toUpperCopy(this.ownerIn);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel1In(String ... orgLevel1) {
        this.orgLevel1In = this.toUpperCopy(orgLevel1);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel2In(String ... orgLevel2) {
        this.orgLevel2In = this.toUpperCopy(orgLevel2);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel3In(String ... orgLevel3) {
        this.orgLevel3In = this.toUpperCopy(orgLevel3);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel4In(String ... orgLevel4) {
        this.orgLevel4In = this.toUpperCopy(orgLevel4);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery customAttributeIn(WorkbasketCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4In = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public WorkbasketHistoryQuery customAttributeLike(WorkbasketCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public WorkbasketHistoryQuery workbasketIdLike(String ... workbasketId) {
        this.workbasketIdLike = this.toUpperCopy(workbasketId);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery eventTypeLike(String ... eventType) {
        this.eventTypeLike = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery userIdLike(String ... userId) {
        this.userIdLike = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery domainLike(String ... domain) {
        this.domainLike = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery workbasketKeyLike(String ... workbasketKey) {
        this.keyLike = this.toUpperCopy(workbasketKey);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery workbasketTypeLike(String ... workbasketType) {
        this.typeLike = this.toUpperCopy(workbasketType);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery ownerLike(String ... ownerLike) {
        this.ownerLike = this.toUpperCopy(ownerLike);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel1Like(String ... orgLevel1) {
        this.orgLevel1Like = this.toUpperCopy(orgLevel1);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel2Like(String ... orgLevel2) {
        this.orgLevel2Like = this.toUpperCopy(orgLevel2);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel3Like(String ... orgLevel3) {
        this.orgLevel3Like = this.toUpperCopy(orgLevel3);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orgLevel4Like(String ... orgLevel4) {
        this.orgLevel4Like = this.toUpperCopy(orgLevel4);
        return this;
    }

    @Override
    public WorkbasketHistoryQuery orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByEventType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("EVENT_TYPE", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByUserId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("USER_ID", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("KEY", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TYPE", sortDirection);
    }

    @Override
    public WorkbasketHistoryQuery orderByCustomAttribute(int num, BaseQuery.SortDirection sortDirection) throws InvalidArgumentException {
        switch (num) {
            case 1: {
                return this.addOrderCriteria("CUSTOM_1", sortDirection);
            }
            case 2: {
                return this.addOrderCriteria("CUSTOM_2", sortDirection);
            }
            case 3: {
                return this.addOrderCriteria("CUSTOM_3", sortDirection);
            }
            case 4: {
                return this.addOrderCriteria("CUSTOM_4", sortDirection);
            }
        }
        throw new InvalidArgumentException("Custom number has to be between 1 and 4, but this is: " + num);
    }

    @Override
    public WorkbasketHistoryQuery orderByOrgLevel(int num, BaseQuery.SortDirection sortDirection) throws InvalidArgumentException {
        switch (num) {
            case 1: {
                return this.addOrderCriteria("ORGLEVEL_1", sortDirection);
            }
            case 2: {
                return this.addOrderCriteria("ORGLEVEL_2", sortDirection);
            }
            case 3: {
                return this.addOrderCriteria("ORGLEVEL_3", sortDirection);
            }
            case 4: {
                return this.addOrderCriteria("ORGLEVEL_4", sortDirection);
            }
        }
        throw new InvalidArgumentException("Org number has to be between 1 and 4, but this is: " + num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkbasketHistoryEvent> list() {
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<WorkbasketHistoryEvent> result = new ArrayList<WorkbasketHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            List<WorkbasketHistoryEvent> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<WorkbasketHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkbasketHistoryEvent> list(int offset, int limit) {
        LOGGER.debug("entry to list({},{}), this = {}", new Object[]{offset, limit, this});
        List<Object> result = new ArrayList<WorkbasketHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List<Object> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<WorkbasketHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listValues(WorkbasketHistoryQueryColumnName dbColumnName, BaseQuery.SortDirection sortDirection) {
        LOGGER.debug("entry to listValues() of column {} with sortDirection {}, this {}", new Object[]{dbColumnName, sortDirection, this});
        List<String> result = new ArrayList<String>();
        this.columnName = dbColumnName;
        List<String> cacheOrderBy = this.orderBy;
        this.orderBy.clear();
        this.addOrderCriteria(this.columnName.toString(), sortDirection);
        try {
            this.taskanaHistoryEngine.openConnection();
            List<String> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_VALUE_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.orderBy = cacheOrderBy;
            this.columnName = null;
            this.orderColumns.remove(this.orderColumns.size() - 1);
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkbasketHistoryEvent single() {
        WorkbasketHistoryEvent workbasketHistoryEvent;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketHistoryEvent result = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            workbasketHistoryEvent = result = (WorkbasketHistoryEvent)this.taskanaHistoryEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaHistoryEngine.returnConnection();
        }
        catch (SQLException e) {
            WorkbasketHistoryEvent workbasketHistoryEvent2;
            try {
                LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                workbasketHistoryEvent2 = result;
                this.taskanaHistoryEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                LOGGER.debug("exit from single(). Returning result {} ", result);
                throw throwable;
            }
            LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
            return workbasketHistoryEvent2;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return workbasketHistoryEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            rowCount = (Long)this.taskanaHistoryEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaHistoryEngine.returnConnection();
        }
        catch (SQLException e) {
            long l2;
            try {
                LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                l2 = -1L;
                this.taskanaHistoryEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                LOGGER.debug("exit from count(). Returning result {} ", rowCount);
                throw throwable;
            }
            LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
            return l2;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private WorkbasketHistoryQueryImpl addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection);
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }
}

