/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.simplehistory.TaskanaHistoryEngine;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryEventMapper;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryEventMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryEventMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper;
import pro.taskana.spi.history.api.TaskanaHistory;

public class TaskanaHistoryEngineImpl
implements TaskanaHistoryEngine {
    protected static final ThreadLocal<Deque<SqlSessionManager>> SESSION_STACK;
    private static final Logger LOGGER;
    private static final String DEFAULT = "default";
    private final SqlSessionManager sessionManager;
    private final TaskanaEngineConfiguration taskanaEngineConfiguration;
    private final TaskanaEngine taskanaEngine;
    private TransactionFactory transactionFactory;
    private TaskanaHistory taskanaHistoryService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    static {
        TaskanaHistoryEngineImpl.ajc$preClinit();
        SESSION_STACK = new ThreadLocal();
        LOGGER = LoggerFactory.getLogger(TaskanaHistoryEngineImpl.class);
    }

    protected TaskanaHistoryEngineImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineConfiguration = taskanaEngine.getConfiguration();
        this.taskanaEngine = taskanaEngine;
        this.createTransactionFactory(this.taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
    }

    public static TaskanaHistoryEngineImpl createTaskanaEngine(TaskanaEngine taskanaEngine) {
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl;
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl2;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl3 = taskanaHistoryEngineImpl2 = (taskanaHistoryEngineImpl = new TaskanaHistoryEngineImpl(taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaHistoryEngineImpl2);
        return taskanaHistoryEngineImpl;
    }

    @Override
    public TaskanaHistory getTaskanaHistoryService() {
        TaskanaHistory taskanaHistory;
        TaskanaHistory taskanaHistory2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.taskanaHistoryService == null) {
            SimpleHistoryServiceImpl historyService = new SimpleHistoryServiceImpl();
            historyService.initialize(this.taskanaEngine);
            this.taskanaHistoryService = historyService;
        }
        TaskanaHistory taskanaHistory3 = taskanaHistory2 = (taskanaHistory = this.taskanaHistoryService);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaHistory2);
        return taskanaHistory;
    }

    @Override
    public boolean isUserInRole(TaskanaRole ... roles) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        TaskanaRole[] taskanaRoleArray = roles;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskanaRoleArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.getConfiguration().isSecurityEnabled()) {
            bl2 = bl3 = true;
        } else {
            Set rolesMembers = Arrays.stream(roles).map(role -> (Set)this.getConfiguration().getRoleMap().get(role)).collect(HashSet::new, Set::addAll, Set::addAll);
            bl2 = bl3 = this.taskanaEngine.getCurrentUserContext().getAccessIds().stream().anyMatch(rolesMembers::contains);
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    @Override
    public void checkRoleMembership(TaskanaRole ... roles) throws NotAuthorizedException {
        TaskanaRole[] taskanaRoleArray = roles;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskanaRoleArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)this.taskanaEngine.getCurrentUserContext().getAccessIds(), (Object)Arrays.toString(roles));
            }
            throw new NotAuthorizedException("current user is not member of role(s) " + Arrays.toString(roles), this.taskanaEngine.getCurrentUserContext().getUserid());
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public TaskanaEngineConfiguration getConfiguration() {
        TaskanaEngineConfiguration taskanaEngineConfiguration;
        TaskanaEngineConfiguration taskanaEngineConfiguration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngineConfiguration taskanaEngineConfiguration3 = taskanaEngineConfiguration2 = (taskanaEngineConfiguration = this.taskanaEngineConfiguration);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngineConfiguration2);
        return taskanaEngineConfiguration;
    }

    protected SqlSessionManager createSqlSessionManager() {
        SqlSessionManager sqlSessionManager;
        SqlSessionManager sqlSessionManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Environment environment = new Environment(DEFAULT, this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
        Configuration configuration = new Configuration(environment);
        configuration.addMapper(TaskHistoryEventMapper.class);
        configuration.addMapper(TaskHistoryQueryMapper.class);
        configuration.addMapper(WorkbasketHistoryEventMapper.class);
        configuration.addMapper(WorkbasketHistoryQueryMapper.class);
        configuration.addMapper(ClassificationHistoryEventMapper.class);
        configuration.addMapper(ClassificationHistoryQueryMapper.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
        return sqlSessionManager;
    }

    protected static void pushSessionToStack(SqlSessionManager session) {
        SqlSessionManager sqlSessionManager = session;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)sqlSessionManager);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaHistoryEngineImpl.getSessionStack().push(session);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    protected static void popSessionFromStack() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Deque<SqlSessionManager> stack = TaskanaHistoryEngineImpl.getSessionStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    protected static Deque<SqlSessionManager> getSessionStack() {
        Deque<SqlSessionManager> deque;
        Deque<SqlSessionManager> deque2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Deque<SqlSessionManager> stack = SESSION_STACK.get();
        if (stack == null) {
            stack = new ArrayDeque<SqlSessionManager>();
            SESSION_STACK.set(stack);
        }
        Deque<SqlSessionManager> deque3 = deque2 = (deque = stack);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, deque2);
        return deque;
    }

    protected static SqlSessionManager getSessionFromStack() {
        SqlSessionManager sqlSessionManager;
        SqlSessionManager sqlSessionManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Deque<SqlSessionManager> stack = TaskanaHistoryEngineImpl.getSessionStack();
        SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = stack.isEmpty() ? (sqlSessionManager = null) : (sqlSessionManager = stack.peek());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
        return sqlSessionManager;
    }

    void openConnection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.initSqlSession();
        this.sessionManager.getConnection().setSchema(this.taskanaEngineConfiguration.getSchemaName());
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    void returnConnection() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaHistoryEngineImpl.popSessionFromStack();
        if (TaskanaHistoryEngineImpl.getSessionStack().isEmpty() && this.sessionManager != null && this.sessionManager.isManagedSessionStarted()) {
            try {
                this.sessionManager.commit();
            }
            catch (Exception exception) {}
            this.sessionManager.close();
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    void initSqlSession() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.sessionManager.startManagedSession();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    SqlSession getSqlSession() {
        SqlSessionManager sqlSessionManager;
        SqlSessionManager sqlSessionManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = this.sessionManager);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
        return sqlSessionManager;
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        boolean bl = useManagedTransactions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaHistoryEngineImpl.java", TaskanaHistoryEngineImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createTaskanaEngine", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskanaHistoryService", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "pro.taskana.spi.history.api.TaskanaHistory"), 59);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "openConnection", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "java.sql.SQLException", "void"), 166);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "returnConnection", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "void"), 177);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "initSqlSession", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "void"), 192);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getSqlSession", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSession"), 201);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransactionFactory", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "boolean", "useManagedTransactions", "", "void"), 210);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "isUserInRole", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "[Lpro.taskana.common.api.TaskanaRole;", "roles", "", "boolean"), 68);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "checkRoleMembership", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "[Lpro.taskana.common.api.TaskanaRole;", "roles", "pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 82);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfiguration", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "pro.taskana.TaskanaEngineConfiguration"), 96);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createSqlSessionManager", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSessionManager"), 100);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "pushSessionToStack", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "org.apache.ibatis.session.SqlSessionManager", "session", "", "void"), 118);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "popSessionFromStack", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "void"), 122);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getSessionStack", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "java.util.Deque"), 143);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getSessionFromStack", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSessionManager"), 152);
    }
}

