/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEventType;

public class HistoryCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_JOB_HISTORY_BATCH_SIZE = "taskana.jobs.history.batchSize";
    private static final String TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE = "taskana.jobs.history.cleanup.minimumAge";
    private final boolean allCompletedSameParentBusiness;
    TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private Duration minimumAge;
    private int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        HistoryCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(HistoryCleanupJob.class);
    }

    public HistoryCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob);
        this.taskanaHistoryEngine = TaskanaHistoryEngineImpl.createTaskanaEngine((TaskanaEngine)this.taskanaEngineImpl);
        this.minimumAge = Duration.parse("P14D");
        this.batchSize = 100;
        this.allCompletedSameParentBusiness = taskanaEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
        Properties props = this.readPropertiesFromFile(TASKANA_PROPERTIES);
        this.initJobParameters(props);
    }

    public void run() throws TaskanaException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant createdBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all history events created before ({})", (Object)createdBefore);
        try {
            try {
                Set taskIdsToDeleteHistoryEventsFor;
                SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
                List historyEventCandidatesToClean = simpleHistoryService.createTaskHistoryQuery().createdWithin(new TimeInterval(null, createdBefore)).eventTypeIn(TaskHistoryEventType.COMPLETED.getName(), TaskHistoryEventType.CANCELLED.getName(), TaskHistoryEventType.TERMINATED.getName()).list();
                if (this.allCompletedSameParentBusiness) {
                    taskIdsToDeleteHistoryEventsFor = historyEventCandidatesToClean.stream().filter(event -> event.getParentBusinessProcessId() == null || event.getParentBusinessProcessId().isEmpty()).map(TaskHistoryEvent::getTaskId).collect(Collectors.toSet());
                    historyEventCandidatesToClean.removeIf(event -> taskIdsToDeleteHistoryEventsFor.contains(event.getTaskId()));
                    if (!historyEventCandidatesToClean.isEmpty()) {
                        String[] parentBusinessProcessIds = (String[])historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getParentBusinessProcessId).distinct().toArray(String[]::new);
                        historyEventCandidatesToClean.addAll(simpleHistoryService.createTaskHistoryQuery().parentBusinessProcessIdIn(parentBusinessProcessIds).eventTypeIn(TaskHistoryEventType.CREATED.getName()).list());
                        taskIdsToDeleteHistoryEventsFor.addAll(this.filterSameParentBusinessHistoryEventsQualifiedToClean(historyEventCandidatesToClean));
                    }
                } else {
                    taskIdsToDeleteHistoryEventsFor = historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getTaskId).collect(Collectors.toSet());
                }
                int totalNumberOfHistoryEventsDeleted = CollectionUtil.partitionBasedOnSize(taskIdsToDeleteHistoryEventsFor, (int)this.batchSize).stream().mapToInt(this::deleteHistoryEventsTransactionally).sum();
                LOGGER.info("Job ended successfully. {} history events deleted.", (Object)totalNumberOfHistoryEventsDeleted);
            }
            catch (Exception e) {
                throw new TaskanaException("Error while processing HistoryCleanupJob.", (Throwable)e);
            }
        }
        finally {
            this.scheduleNextCleanupJob();
        }
        Object var9_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_10);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        jobService.deleteJobs(ScheduledJob.Type.HISTORYCLEANUPJOB);
        HistoryCleanupJob job = new HistoryCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private List<String> filterSameParentBusinessHistoryEventsQualifiedToClean(List<TaskHistoryEvent> historyEventCandidatesToClean) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<TaskHistoryEvent> list = historyEventCandidatesToClean;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map historyEventsGroupedByParentBusinessProcessIdAndType = historyEventCandidatesToClean.stream().collect(Collectors.groupingBy(TaskHistoryEvent::getParentBusinessProcessId, Collectors.groupingBy(TaskHistoryEvent::getEventType, Collectors.mapping(TaskHistoryEvent::getTaskId, Collectors.toList()))));
        ArrayList<String> taskIdsToDeleteHistoryEventsFor = new ArrayList<String>();
        historyEventsGroupedByParentBusinessProcessIdAndType.entrySet().forEach(idsOfTasksInSameParentBusinessProcessGroupedByType -> {
            if (((List)((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).get(TaskHistoryEventType.CREATED.getName())).size() == ((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(TaskHistoryEventType.CREATED.getName())).mapToInt(stringListEntry -> ((List)stringListEntry.getValue()).size()).sum()) {
                taskIdsToDeleteHistoryEventsFor.addAll((Collection)((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).get(TaskHistoryEventType.CREATED.getName()));
            }
        });
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = taskIdsToDeleteHistoryEventsFor);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private int deleteHistoryEventsTransactionally(List<String> taskIdsToDeleteHistoryEventsFor) {
        int n;
        int n2;
        int n3;
        List<String> list = taskIdsToDeleteHistoryEventsFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int deletedEventsCount = 0;
        if (this.txProvider != null) {
            n2 = n3 = ((Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteEvents(taskIdsToDeleteHistoryEventsFor);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete history events.", (Throwable)e);
                    return 0;
                }
            })).intValue();
        } else {
            try {
                deletedEventsCount = this.deleteEvents(taskIdsToDeleteHistoryEventsFor);
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete history events.", (Throwable)e);
            }
            n2 = n3 = deletedEventsCount;
        }
        int n4 = n = n2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
        return n3;
    }

    private int deleteEvents(List<String> taskIdsToDeleteHistoryEventsFor) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<String> list = taskIdsToDeleteHistoryEventsFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
        String[] taskIdsArray = new String[taskIdsToDeleteHistoryEventsFor.size()];
        int deletedTasksCount = (int)simpleHistoryService.createTaskHistoryQuery().taskIdIn(taskIdsToDeleteHistoryEventsFor.toArray(taskIdsArray)).count();
        simpleHistoryService.deleteHistoryEventsByTaskIds(taskIdsToDeleteHistoryEventsFor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} events deleted.", (Object)deletedTasksCount);
        }
        int n3 = n2 = (n = deletedTasksCount);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private void scheduleNextCleanupJob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.HISTORYCLEANUPJOB);
        job.setDue(this.getNextDueForCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    private void initJobParameters(Properties props) {
        String historyEventCleanupJobMinimumAgeProperty;
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String jobBatchSizeProperty = props.getProperty(TASKANA_JOB_HISTORY_BATCH_SIZE);
        if (jobBatchSizeProperty != null && !jobBatchSizeProperty.isEmpty()) {
            try {
                this.batchSize = Integer.parseInt(jobBatchSizeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse jobBatchSizeProperty ({}). Using default. Exception: {} ", (Object)jobBatchSizeProperty, (Object)e.getMessage());
            }
        }
        if ((historyEventCleanupJobMinimumAgeProperty = props.getProperty(TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE)) != null && !historyEventCleanupJobMinimumAgeProperty.isEmpty()) {
            try {
                this.minimumAge = Duration.parse(historyEventCleanupJobMinimumAgeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse historyEventCleanupJobMinimumAgeProperty ({}). Using default. Exception: {} ", (Object)historyEventCleanupJobMinimumAgeProperty, (Object)e.getMessage());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured number of history events per transaction: {}", (Object)this.batchSize);
            LOGGER.debug("HistoryCleanupJob configuration: runs every {}", (Object)this.runEvery);
            LOGGER.debug("HistoryCleanupJob configuration: minimum age of history events to be cleanup up is {}", (Object)this.minimumAge);
        }
        Object var7_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_8);
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties properties;
        Properties properties2;
        Properties props;
        JoinPoint joinPoint;
        block16: {
            String string = propertiesFile;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            props = new Properties();
            boolean loadFromClasspath = this.loadFromClasspath(propertiesFile);
            try {
                if (loadFromClasspath) {
                    InputStream inputStream = TaskanaEngineConfiguration.class.getResourceAsStream(propertiesFile);
                    if (inputStream == null) {
                        LOGGER.error("taskana properties file {} was not found on classpath.", (Object)propertiesFile);
                    } else {
                        props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("taskana properties were loaded from file {} from classpath.", (Object)propertiesFile);
                        }
                    }
                    break block16;
                }
                Throwable inputStream = null;
                Object var5_10 = null;
                try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
                    props.load(fileInputStream);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("taskana properties were loaded from file {}.", (Object)propertiesFile);
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream == null) {
                        inputStream = throwable;
                    } else if (inputStream != throwable) {
                        inputStream.addSuppressed(throwable);
                    }
                    throw inputStream;
                }
            }
            catch (IOException e) {
                LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
                throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
            }
        }
        Properties properties3 = properties2 = (properties = props);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    private boolean loadFromClasspath(String propertiesFile) {
        boolean bl;
        boolean bl2;
        String string = propertiesFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean loadFromClasspath = true;
        File f = new File(propertiesFile);
        if (f.exists() && !f.isDirectory()) {
            loadFromClasspath = false;
        }
        boolean bl3 = bl2 = (bl = loadFromClasspath);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HistoryCleanupJob.java", HistoryCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "", "", "pro.taskana.common.api.exceptions.TaskanaException", "void"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 150);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterSameParentBusinessHistoryEventsQualifiedToClean", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "historyEventCandidatesToClean", "", "java.util.List"), 157);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteHistoryEventsTransactionally", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "taskIdsToDeleteHistoryEventsFor", "", "int"), 198);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteEvents", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "taskIdsToDeleteHistoryEventsFor", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "int"), 221);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scheduleNextCleanupJob", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "", "", "", "void"), 243);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initJobParameters", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.Properties", "props", "", "void"), 250);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readPropertiesFromFile", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.lang.String", "propertiesFile", "", "java.util.Properties"), 288);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadFromClasspath", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.lang.String", "propertiesFile", "", "boolean"), 320);
    }
}

