/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.simplehistory.impl.ClassificationHistoryQueryImpl;
import pro.taskana.simplehistory.impl.TaskHistoryQueryImpl;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.simplehistory.impl.WorkbasketHistoryQueryImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryEventMapper;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery;
import pro.taskana.simplehistory.impl.task.TaskHistoryEventMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryEventMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

public class SimpleHistoryServiceImpl
implements TaskanaHistory {
    private static final Logger LOGGER;
    private TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private TaskHistoryEventMapper taskHistoryEventMapper;
    private WorkbasketHistoryEventMapper workbasketHistoryEventMapper;
    private ClassificationHistoryEventMapper classificationHistoryEventMapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        SimpleHistoryServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SimpleHistoryServiceImpl.class);
    }

    public void initialize(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaHistoryEngine = this.getTaskanaEngine(taskanaEngine);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Simple history service implementation initialized with schemaName: {} ", (Object)taskanaEngine.getConfiguration().getSchemaName());
        }
        this.taskHistoryEventMapper = (TaskHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(TaskHistoryEventMapper.class);
        this.workbasketHistoryEventMapper = (WorkbasketHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(WorkbasketHistoryEventMapper.class);
        this.classificationHistoryEventMapper = (ClassificationHistoryEventMapper)this.taskanaHistoryEngine.getSqlSession().getMapper(ClassificationHistoryEventMapper.class);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void create(TaskHistoryEvent event) {
        JoinPoint joinPoint;
        block6: {
            TaskHistoryEvent taskHistoryEvent = event;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskHistoryEvent);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                try {
                    this.taskanaHistoryEngine.openConnection();
                    if (event.getCreated() == null) {
                        Instant now = Instant.now();
                        event.setCreated(now);
                    }
                    this.taskHistoryEventMapper.insert(event);
                }
                catch (SQLException e) {
                    LOGGER.error("Error while inserting task history event into database", (Throwable)e);
                    this.taskanaHistoryEngine.returnConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                throw throwable;
            }
            this.taskanaHistoryEngine.returnConnection();
        }
        Object var6_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_7);
    }

    public void create(WorkbasketHistoryEvent event) {
        JoinPoint joinPoint;
        block6: {
            WorkbasketHistoryEvent workbasketHistoryEvent = event;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                try {
                    this.taskanaHistoryEngine.openConnection();
                    if (event.getCreated() == null) {
                        Instant now = Instant.now();
                        event.setCreated(now);
                    }
                    this.workbasketHistoryEventMapper.insert(event);
                }
                catch (SQLException e) {
                    LOGGER.error("Error while inserting workbasket history event into database", (Throwable)e);
                    this.taskanaHistoryEngine.returnConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                throw throwable;
            }
            this.taskanaHistoryEngine.returnConnection();
        }
        Object var6_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_7);
    }

    public void create(ClassificationHistoryEvent event) {
        JoinPoint joinPoint;
        block6: {
            ClassificationHistoryEvent classificationHistoryEvent = event;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)classificationHistoryEvent);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                try {
                    this.taskanaHistoryEngine.openConnection();
                    if (event.getCreated() == null) {
                        Instant now = Instant.now();
                        event.setCreated(now);
                    }
                    this.classificationHistoryEventMapper.insert(event);
                }
                catch (SQLException e) {
                    LOGGER.error("Error while inserting classification history event into database", (Throwable)e);
                    this.taskanaHistoryEngine.returnConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                throw throwable;
            }
            this.taskanaHistoryEngine.returnConnection();
        }
        Object var6_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_7);
    }

    public void deleteHistoryEventsByTaskIds(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        JoinPoint joinPoint;
        block6: {
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskanaHistoryEngine.checkRoleMembership(TaskanaRole.ADMIN);
            if (taskIds == null) {
                throw new InvalidArgumentException("List of taskIds must not be null.");
            }
            try {
                try {
                    this.taskanaHistoryEngine.openConnection();
                    this.taskHistoryEventMapper.deleteMultipleByTaskIds(taskIds);
                }
                catch (SQLException e) {
                    LOGGER.error("Caught exception while trying to delete history events", (Throwable)e);
                    this.taskanaHistoryEngine.returnConnection();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                throw throwable;
            }
            this.taskanaHistoryEngine.returnConnection();
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    public TaskHistoryEvent getTaskHistoryEvent(String historyEventId) throws TaskanaHistoryEventNotFoundException {
        TaskHistoryEvent taskHistoryEvent;
        TaskHistoryEvent taskHistoryEvent2;
        TaskHistoryEvent taskHistoryEvent3;
        String string = historyEventId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskHistoryEvent resultEvent = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            resultEvent = this.taskHistoryEventMapper.findById(historyEventId);
            if (resultEvent == null) {
                throw new TaskanaHistoryEventNotFoundException(historyEventId);
            }
            TaskHistoryEvent taskHistoryEvent4 = resultEvent;
            taskHistoryEvent2 = taskHistoryEvent3 = taskHistoryEvent4;
        }
        catch (SQLException e) {
            LOGGER.error("Caught exception while trying to retrieve a history event", (Throwable)e);
            TaskHistoryEvent taskHistoryEvent5 = resultEvent;
            taskHistoryEvent2 = taskHistoryEvent3 = taskHistoryEvent5;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
        }
        TaskHistoryEvent taskHistoryEvent6 = taskHistoryEvent = taskHistoryEvent2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryEvent);
        return taskHistoryEvent3;
    }

    public TaskHistoryQuery createTaskHistoryQuery() {
        TaskHistoryQueryImpl taskHistoryQueryImpl;
        TaskHistoryQueryImpl taskHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskHistoryQueryImpl taskHistoryQueryImpl3 = taskHistoryQueryImpl2 = (taskHistoryQueryImpl = new TaskHistoryQueryImpl(this.taskanaHistoryEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryQueryImpl2);
        return taskHistoryQueryImpl;
    }

    public WorkbasketHistoryQuery createWorkbasketHistoryQuery() {
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl;
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl3 = workbasketHistoryQueryImpl2 = (workbasketHistoryQueryImpl = new WorkbasketHistoryQueryImpl(this.taskanaHistoryEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketHistoryQueryImpl2);
        return workbasketHistoryQueryImpl;
    }

    public ClassificationHistoryQuery createClassificationHistoryQuery() {
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl;
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl3 = classificationHistoryQueryImpl2 = (classificationHistoryQueryImpl = new ClassificationHistoryQueryImpl(this.taskanaHistoryEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationHistoryQueryImpl2);
        return classificationHistoryQueryImpl;
    }

    TaskanaHistoryEngineImpl getTaskanaEngine(TaskanaEngine taskanaEngine) {
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl;
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl2;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaHistoryEngineImpl taskanaHistoryEngineImpl3 = taskanaHistoryEngineImpl2 = (taskanaHistoryEngineImpl = TaskanaHistoryEngineImpl.createTaskanaEngine(taskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaHistoryEngineImpl2);
        return taskanaHistoryEngineImpl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SimpleHistoryServiceImpl.java", SimpleHistoryServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 34);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 69);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 85);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsByTaskIds", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskHistoryEvent", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "java.lang.String", "historyEventId", "pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent"), 119);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.task.TaskHistoryQuery"), 140);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasketHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery"), 144);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClassificationHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery"), 148);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskanaEngine", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl"), 155);
    }
}

