/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.common.internal.util.CollectionUtil;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEventType;

public class HistoryCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER;
    private static final String TASKANA_JOB_HISTORY_BATCH_SIZE = "taskana.jobs.history.batchSize";
    private static final String TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE = "taskana.jobs.history.cleanup.minimumAge";
    private final TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private final boolean allCompletedSameParentBusiness;
    private Duration minimumAge;
    private int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        HistoryCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(HistoryCleanupJob.class);
    }

    public HistoryCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob, true);
        this.taskanaHistoryEngine = TaskanaHistoryEngineImpl.createTaskanaEngine((TaskanaEngine)this.taskanaEngineImpl);
        this.minimumAge = this.taskanaEngineImpl.getConfiguration().getCleanupJobMinimumAge();
        this.batchSize = this.taskanaEngineImpl.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
        this.allCompletedSameParentBusiness = taskanaEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
        Properties props = taskanaEngine.getConfiguration().readPropertiesFromFile();
        this.initJobParameters(props);
    }

    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant createdBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all history events created before ({})", (Object)createdBefore);
        try {
            Set taskIdsToDeleteHistoryEventsFor;
            SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
            List historyEventCandidatesToClean = simpleHistoryService.createTaskHistoryQuery().createdWithin(new TimeInterval(null, createdBefore)).eventTypeIn(TaskHistoryEventType.COMPLETED.getName(), TaskHistoryEventType.CANCELLED.getName(), TaskHistoryEventType.TERMINATED.getName()).list();
            if (this.allCompletedSameParentBusiness) {
                taskIdsToDeleteHistoryEventsFor = historyEventCandidatesToClean.stream().filter(event -> event.getParentBusinessProcessId() == null || event.getParentBusinessProcessId().isEmpty()).map(TaskHistoryEvent::getTaskId).collect(Collectors.toSet());
                historyEventCandidatesToClean.removeIf(event -> taskIdsToDeleteHistoryEventsFor.contains(event.getTaskId()));
                if (!historyEventCandidatesToClean.isEmpty()) {
                    String[] parentBusinessProcessIds = (String[])historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getParentBusinessProcessId).distinct().toArray(String[]::new);
                    historyEventCandidatesToClean.addAll(simpleHistoryService.createTaskHistoryQuery().parentBusinessProcessIdIn(parentBusinessProcessIds).eventTypeIn(TaskHistoryEventType.CREATED.getName()).list());
                    taskIdsToDeleteHistoryEventsFor.addAll(this.filterSameParentBusinessHistoryEventsQualifiedToClean(historyEventCandidatesToClean));
                }
            } else {
                taskIdsToDeleteHistoryEventsFor = historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getTaskId).collect(Collectors.toSet());
            }
            int totalNumberOfHistoryEventsDeleted = CollectionUtil.partitionBasedOnSize(taskIdsToDeleteHistoryEventsFor, (int)this.batchSize).stream().mapToInt(this::deleteHistoryEventsTransactionally).sum();
            LOGGER.info("Job ended successfully. {} history events deleted.", (Object)totalNumberOfHistoryEventsDeleted);
        }
        catch (Exception e) {
            throw new SystemException("Error while processing HistoryCleanupJob.", (Throwable)e);
        }
        Object var7_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_9);
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        HistoryCleanupJob job = new HistoryCleanupJob(taskanaEngine, null, null);
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = HistoryCleanupJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private List<String> filterSameParentBusinessHistoryEventsQualifiedToClean(List<TaskHistoryEvent> historyEventCandidatesToClean) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<TaskHistoryEvent> list = historyEventCandidatesToClean;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map taskHistoryIdsByEventTypeByParentBusinessProcessId = historyEventCandidatesToClean.stream().collect(Collectors.groupingBy(TaskHistoryEvent::getParentBusinessProcessId, Collectors.groupingBy(TaskHistoryEvent::getEventType, Collectors.mapping(TaskHistoryEvent::getTaskId, Collectors.toList()))));
        ArrayList<String> taskIdsToDeleteHistoryEventsFor = new ArrayList<String>();
        String createdKey = TaskHistoryEventType.CREATED.getName();
        taskHistoryIdsByEventTypeByParentBusinessProcessId.forEach((parentBusinessProcessId, taskHistoryIdsByEventType) -> {
            if (!taskHistoryIdsByEventType.containsKey(createdKey)) {
                LOGGER.error("Issue during history cleanup tasks with enabled parent business process. No events for parent business process {} with type {} found.Please clean up those history events manually", parentBusinessProcessId, (Object)createdKey);
            } else if (((List)taskHistoryIdsByEventType.get(createdKey)).size() == taskHistoryIdsByEventType.entrySet().stream().filter(Predicate.not(entry -> ((String)entry.getKey()).equals(createdKey))).mapToInt(stringListEntry -> ((List)stringListEntry.getValue()).size()).sum()) {
                taskIdsToDeleteHistoryEventsFor.addAll((Collection)taskHistoryIdsByEventType.get(createdKey));
            }
        });
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = taskIdsToDeleteHistoryEventsFor);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private int deleteHistoryEventsTransactionally(List<String> taskIdsToDeleteHistoryEventsFor) {
        int n;
        int n2;
        List<String> list = taskIdsToDeleteHistoryEventsFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = ((Integer)TaskanaTransactionProvider.executeInTransactionIfPossible((TaskanaTransactionProvider)this.txProvider, () -> {
            try {
                return this.deleteEvents(taskIdsToDeleteHistoryEventsFor);
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete history events.", (Throwable)e);
                return 0;
            }
        })).intValue());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private int deleteEvents(List<String> taskIdsToDeleteHistoryEventsFor) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<String> list = taskIdsToDeleteHistoryEventsFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
        int deletedTasksCount = (int)simpleHistoryService.createTaskHistoryQuery().taskIdIn(taskIdsToDeleteHistoryEventsFor.toArray(new String[0])).count();
        simpleHistoryService.deleteHistoryEventsByTaskIds(taskIdsToDeleteHistoryEventsFor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} events deleted.", (Object)deletedTasksCount);
        }
        int n3 = n2 = (n = deletedTasksCount);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private void initJobParameters(Properties props) {
        String historyEventCleanupJobMinimumAgeProperty;
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)properties);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String jobBatchSizeProperty = props.getProperty(TASKANA_JOB_HISTORY_BATCH_SIZE);
        if (jobBatchSizeProperty != null && !jobBatchSizeProperty.isEmpty()) {
            try {
                this.batchSize = Integer.parseInt(jobBatchSizeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse jobBatchSizeProperty ({}). Using default. Exception: {} ", (Object)jobBatchSizeProperty, (Object)e.getMessage());
            }
        }
        if ((historyEventCleanupJobMinimumAgeProperty = props.getProperty(TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE)) != null && !historyEventCleanupJobMinimumAgeProperty.isEmpty()) {
            try {
                this.minimumAge = Duration.parse(historyEventCleanupJobMinimumAgeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse historyEventCleanupJobMinimumAgeProperty ({}). Using default. Exception: {} ", (Object)historyEventCleanupJobMinimumAgeProperty, (Object)e.getMessage());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured number of history events per transaction: {}", (Object)this.batchSize);
            LOGGER.debug("HistoryCleanupJob configuration: runs every {}", (Object)this.runEvery);
            LOGGER.debug("HistoryCleanupJob configuration: minimum age of history events to be cleanup up is {}", (Object)this.minimumAge);
        }
        Object var7_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_8);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HistoryCleanupJob.java", HistoryCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "", "", "", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 139);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "", "", "", "java.lang.String"), 147);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterSameParentBusinessHistoryEventsQualifiedToClean", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "historyEventCandidatesToClean", "", "java.util.List"), 151);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteHistoryEventsTransactionally", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "taskIdsToDeleteHistoryEventsFor", "", "int"), 187);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteEvents", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.List", "taskIdsToDeleteHistoryEventsFor", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "int"), 200);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initJobParameters", "pro.taskana.simplehistory.impl.jobs.HistoryCleanupJob", "java.util.Properties", "props", "", "void"), 221);
    }
}

