/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.lang.reflect.Field;
import java.time.Instant;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.TaskanaEngineImpl;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.simplehistory.impl.ClassificationHistoryQueryImpl;
import pro.taskana.simplehistory.impl.TaskHistoryQueryImpl;
import pro.taskana.simplehistory.impl.WorkbasketHistoryQueryImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryEventMapper;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryEventMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryEventMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;
import pro.taskana.user.internal.UserMapper;
import pro.taskana.user.internal.models.UserImpl;

public class SimpleHistoryServiceImpl
implements TaskanaHistory {
    private static final Logger LOGGER;
    private TaskHistoryEventMapper taskHistoryEventMapper;
    private WorkbasketHistoryEventMapper workbasketHistoryEventMapper;
    private ClassificationHistoryEventMapper classificationHistoryEventMapper;
    private UserMapper userMapper;
    private InternalTaskanaEngine internalTaskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        SimpleHistoryServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SimpleHistoryServiceImpl.class);
    }

    public void initialize(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Simple history service implementation initialized with schemaName: {} ", (Object)taskanaEngine.getConfiguration().getSchemaName());
        Field sessionManager = null;
        try {
            Field internalTaskanaEngineImpl = TaskanaEngineImpl.class.getDeclaredField("internalTaskanaEngineImpl");
            internalTaskanaEngineImpl.setAccessible(true);
            this.internalTaskanaEngine = (InternalTaskanaEngine)internalTaskanaEngineImpl.get(taskanaEngine);
            sessionManager = TaskanaEngineImpl.class.getDeclaredField("sessionManager");
            sessionManager.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new SystemException("SQL Session could not be retrieved. Aborting Startup");
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e.getMessage());
        }
        try {
            SqlSession sqlSession = (SqlSession)sessionManager.get(taskanaEngine);
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(TaskHistoryEventMapper.class)) {
                sqlSession.getConfiguration().addMapper(TaskHistoryEventMapper.class);
            }
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(WorkbasketHistoryEventMapper.class)) {
                sqlSession.getConfiguration().addMapper(WorkbasketHistoryEventMapper.class);
            }
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(ClassificationHistoryEventMapper.class)) {
                sqlSession.getConfiguration().addMapper(ClassificationHistoryEventMapper.class);
            }
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(ClassificationHistoryQueryMapper.class)) {
                sqlSession.getConfiguration().addMapper(ClassificationHistoryQueryMapper.class);
            }
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(TaskHistoryQueryMapper.class)) {
                sqlSession.getConfiguration().addMapper(TaskHistoryQueryMapper.class);
            }
            if (!sqlSession.getConfiguration().getMapperRegistry().hasMapper(WorkbasketHistoryQueryMapper.class)) {
                sqlSession.getConfiguration().addMapper(WorkbasketHistoryQueryMapper.class);
            }
            this.taskHistoryEventMapper = (TaskHistoryEventMapper)sqlSession.getMapper(TaskHistoryEventMapper.class);
            this.workbasketHistoryEventMapper = (WorkbasketHistoryEventMapper)sqlSession.getMapper(WorkbasketHistoryEventMapper.class);
            this.classificationHistoryEventMapper = (ClassificationHistoryEventMapper)sqlSession.getMapper(ClassificationHistoryEventMapper.class);
            this.userMapper = (UserMapper)sqlSession.getMapper(UserMapper.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SystemException("TASKANA engine of Session Manager could not be retrieved. Aborting Startup");
        }
        Object var6_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_7);
    }

    public void create(TaskHistoryEvent event) {
        TaskHistoryEvent taskHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (event.getCreated() == null) {
            Instant now = Instant.now();
            event.setCreated(now);
        }
        this.taskHistoryEventMapper.insert(event);
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(WorkbasketHistoryEvent event) {
        WorkbasketHistoryEvent workbasketHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (event.getCreated() == null) {
            Instant now = Instant.now();
            event.setCreated(now);
        }
        this.workbasketHistoryEventMapper.insert(event);
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(ClassificationHistoryEvent event) {
        ClassificationHistoryEvent classificationHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)classificationHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (event.getCreated() == null) {
            Instant now = Instant.now();
            event.setCreated(now);
        }
        this.classificationHistoryEventMapper.insert(event);
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void deleteHistoryEventsByTaskIds(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.internalTaskanaEngine.getEngine().checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN});
        if (taskIds == null) {
            throw new InvalidArgumentException("List of taskIds must not be null.");
        }
        try {
            this.internalTaskanaEngine.openConnection();
            this.taskHistoryEventMapper.deleteMultipleByTaskIds(taskIds);
        }
        finally {
            this.internalTaskanaEngine.returnConnection();
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public TaskHistoryEvent getTaskHistoryEvent(String historyEventId) throws TaskanaHistoryEventNotFoundException {
        TaskHistoryEvent taskHistoryEvent;
        TaskHistoryEvent taskHistoryEvent2;
        String string = historyEventId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskHistoryEvent resultEvent = null;
        try {
            UserImpl user;
            this.internalTaskanaEngine.openConnection();
            resultEvent = this.taskHistoryEventMapper.findById(historyEventId);
            if (resultEvent == null) {
                throw new TaskanaHistoryEventNotFoundException(historyEventId);
            }
            if (this.internalTaskanaEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(resultEvent.getUserId())) != null) {
                resultEvent.setUserLongName(user.getLongName());
            }
            TaskHistoryEvent taskHistoryEvent3 = resultEvent;
            taskHistoryEvent2 = taskHistoryEvent3;
        }
        finally {
            this.internalTaskanaEngine.returnConnection();
        }
        TaskHistoryEvent taskHistoryEvent4 = taskHistoryEvent = taskHistoryEvent2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryEvent);
        return taskHistoryEvent2;
    }

    public TaskHistoryQuery createTaskHistoryQuery() {
        TaskHistoryQueryImpl taskHistoryQueryImpl;
        TaskHistoryQueryImpl taskHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskHistoryQueryImpl taskHistoryQueryImpl3 = taskHistoryQueryImpl2 = (taskHistoryQueryImpl = new TaskHistoryQueryImpl(this.internalTaskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryQueryImpl2);
        return taskHistoryQueryImpl;
    }

    public WorkbasketHistoryQuery createWorkbasketHistoryQuery() {
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl;
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketHistoryQueryImpl workbasketHistoryQueryImpl3 = workbasketHistoryQueryImpl2 = (workbasketHistoryQueryImpl = new WorkbasketHistoryQueryImpl(this.internalTaskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketHistoryQueryImpl2);
        return workbasketHistoryQueryImpl;
    }

    public ClassificationHistoryQuery createClassificationHistoryQuery() {
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl;
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationHistoryQueryImpl classificationHistoryQueryImpl3 = classificationHistoryQueryImpl2 = (classificationHistoryQueryImpl = new ClassificationHistoryQueryImpl(this.internalTaskanaEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationHistoryQueryImpl2);
        return classificationHistoryQueryImpl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SimpleHistoryServiceImpl.java", SimpleHistoryServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 132);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 142);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsByTaskIds", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "java.util.List", "taskIds", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "void"), 152);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskHistoryEvent", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "java.lang.String", "historyEventId", "pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent"), 170);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.task.TaskHistoryQuery"), 194);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasketHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQuery"), 198);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createClassificationHistoryQuery", "pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl", "", "", "", "pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery"), 202);
    }
}

