/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest.assembler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.simplehistory.rest.TaskHistoryEventController;
import pro.taskana.simplehistory.rest.assembler.TaskHistoryEventRepresentationModelAssembler;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventListResource;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventRepresentationModel;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;

public class TaskHistoryEventListResourceAssembler {
    public TaskHistoryEventListResource toResources(List<TaskHistoryEvent> historyEvents, PagedModel.PageMetadata pageMetadata) {
        TaskHistoryEventRepresentationModelAssembler assembler = new TaskHistoryEventRepresentationModelAssembler();
        ArrayList<TaskHistoryEventRepresentationModel> resources = new ArrayList<TaskHistoryEventRepresentationModel>(assembler.toCollectionModel(historyEvents).getContent());
        TaskHistoryEventListResource pagedResources = new TaskHistoryEventListResource(resources, pageMetadata, new Link[0]);
        pagedResources.add(Link.of((String)this.getBaseUri().toUriString()).withSelfRel());
        if (pageMetadata != null) {
            pagedResources.add(WebMvcLinkBuilder.linkTo(TaskHistoryEventController.class).withRel("allTaskHistoryEvent"));
            pagedResources.add(Link.of((String)this.getBaseUri().replaceQueryParam("page", new Object[]{1}).toUriString()).withRel(IanaLinkRelations.FIRST));
            pagedResources.add(Link.of((String)this.getBaseUri().replaceQueryParam("page", new Object[]{pageMetadata.getTotalPages()}).toUriString()).withRel(IanaLinkRelations.LAST));
            if (pageMetadata.getNumber() > 1L) {
                pagedResources.add(Link.of((String)this.getBaseUri().replaceQueryParam("page", new Object[]{pageMetadata.getNumber() - 1L}).toUriString()).withRel(IanaLinkRelations.PREV));
            }
            if (pageMetadata.getNumber() < pageMetadata.getTotalPages()) {
                pagedResources.add(Link.of((String)this.getBaseUri().replaceQueryParam("page", new Object[]{pageMetadata.getNumber() + 1L}).toUriString()).withRel(IanaLinkRelations.NEXT));
            }
        }
        return pagedResources;
    }

    private UriComponentsBuilder getBaseUri() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        UriComponentsBuilder baseUri = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).path(request.getRequestURI());
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                baseUri.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        return baseUri;
    }
}

