/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.rest.AbstractPagingController;
import pro.taskana.common.rest.QueryHelper;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.rest.assembler.TaskHistoryEventListResourceAssembler;
import pro.taskana.simplehistory.rest.assembler.TaskHistoryEventRepresentationModelAssembler;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventListResource;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventRepresentationModel;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/api/v1/task-history-event"}, produces={"application/hal+json"})
public class TaskHistoryEventController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHistoryEventController.class);
    private static final String LIKE = "%";
    private static final String BUSINESS_PROCESS_ID = "business-process-id";
    private static final String BUSINESS_PROCESS_ID_LIKE = "business-process-id-like";
    private static final String PARENT_BUSINESS_PROCESS_ID = "parent-business-process-id";
    private static final String PARENT_BUSINESS_PROCESS_ID_LIKE = "parent-business-process-id-like";
    private static final String TASK_ID = "task-id";
    private static final String TASK_ID_LIKE = "task-id-like";
    private static final String EVENT_TYPE = "event-type";
    private static final String EVENT_TYPE_LIKE = "event-type-like";
    private static final String CREATED = "created";
    private static final String USER_ID = "user-id";
    private static final String USER_ID_LIKE = "user-id-like";
    private static final String DOMAIN = "domain";
    private static final String WORKBASKET_KEY = "workbasket-key";
    private static final String WORKBASKET_KEY_LIKE = "workbasket-key-like";
    private static final String POR_COMPANY = "por-company";
    private static final String POR_COMPANY_LIKE = "por-company-like";
    private static final String POR_SYSTEM = "por-system";
    private static final String POR_SYSTEM_LIKE = "por-system-like";
    private static final String POR_INSTANCE = "por-instance";
    private static final String POR_INSTANCE_LIKE = "por-instance-like";
    private static final String POR_TYPE = "por-type";
    private static final String POR_TYPE_LIKE = "por-type-like";
    private static final String POR_VALUE = "por-value";
    private static final String POR_VALUE_LIKE = "por-value-like";
    private static final String TASK_CLASSIFICATION_KEY = "task-classification-key";
    private static final String TASK_CLASSIFICATION_KEY_LIKE = "task-classification-key-like";
    private static final String TASK_CLASSIFICATION_CATEGORY = "task-classification-category";
    private static final String TASK_CLASSIFICATION_CATEGORY_LIKE = "task-classification-category-like";
    private static final String ATTACHMENT_CLASSIFICATION_KEY = "attachment-classification-key";
    private static final String ATTACHMENT_CLASSIFICATION_KEY_LIKE = "attachment-classification-key-like";
    private static final String CUSTOM_1 = "custom-1";
    private static final String CUSTOM_2 = "custom-2";
    private static final String CUSTOM_3 = "custom-3";
    private static final String CUSTOM_4 = "custom-4";
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";
    private final SimpleHistoryServiceImpl simpleHistoryService;
    private final TaskHistoryEventRepresentationModelAssembler taskHistoryEventRepresentationModelAssembler;

    @Autowired
    public TaskHistoryEventController(TaskanaEngineConfiguration taskanaEngineConfiguration, SimpleHistoryServiceImpl simpleHistoryServiceImpl, TaskHistoryEventRepresentationModelAssembler taskHistoryEventRepresentationModelAssembler) {
        this.simpleHistoryService = simpleHistoryServiceImpl;
        this.simpleHistoryService.initialize(taskanaEngineConfiguration.buildTaskanaEngine());
        this.taskHistoryEventRepresentationModelAssembler = taskHistoryEventRepresentationModelAssembler;
    }

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventListResource> getTaskHistoryEvents(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        List historyEvents;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskHistoryEvents(params= {})", params);
        }
        TaskHistoryQuery query = this.simpleHistoryService.createTaskHistoryQuery();
        this.applySortingParams(query, params);
        this.applyFilterParams(query, params);
        PagedModel.PageMetadata pageMetadata = null;
        String page = (String)params.getFirst((Object)PAGING_PAGE);
        String pageSize = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE_SIZE);
        this.validateNoInvalidParameterIsLeft(params);
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            historyEvents = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            historyEvents = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        TaskHistoryEventListResourceAssembler assembler = new TaskHistoryEventListResourceAssembler();
        TaskHistoryEventListResource pagedResources = assembler.toResources(historyEvents, pageMetadata);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskHistoryEvents(), returning {}", (Object)new ResponseEntity((Object)pagedResources, HttpStatus.OK));
        }
        return new ResponseEntity((Object)pagedResources, HttpStatus.OK);
    }

    @GetMapping(path={"/{historyEventId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventRepresentationModel> getTaskHistoryEvent(@PathVariable String historyEventId) throws TaskanaHistoryEventNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskHistoryEvent(historyEventId= {})", (Object)historyEventId);
        }
        TaskHistoryEvent resultEvent = this.simpleHistoryService.getTaskHistoryEvent(historyEventId);
        TaskHistoryEventRepresentationModel taskEventResource = this.taskHistoryEventRepresentationModelAssembler.toModel(resultEvent);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskHistoryEvent, returning {}", (Object)new ResponseEntity((Object)taskEventResource, HttpStatus.OK));
        }
        return new ResponseEntity((Object)taskEventResource, HttpStatus.OK);
    }

    private void applySortingParams(TaskHistoryQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(params= {})", params);
        }
        QueryHelper.applyAndRemoveSortingParams(params, (sortBy, sortDirection) -> {
            switch (sortBy) {
                case "business-process-id": {
                    query.orderByBusinessProcessId(sortDirection);
                    break;
                }
                case "parent-business-process-id": {
                    query.orderByParentBusinessProcessId(sortDirection);
                    break;
                }
                case "task-id": {
                    query.orderByTaskId(sortDirection);
                    break;
                }
                case "event-type": {
                    query.orderByEventType(sortDirection);
                    break;
                }
                case "created": {
                    query.orderByCreated(sortDirection);
                    break;
                }
                case "user-id": {
                    query.orderByUserId(sortDirection);
                    break;
                }
                case "domain": {
                    query.orderByDomain(sortDirection);
                    break;
                }
                case "workbasket-key": {
                    query.orderByWorkbasketKey(sortDirection);
                    break;
                }
                case "por-company": {
                    query.orderByPorCompany(sortDirection);
                    break;
                }
                case "por-system": {
                    query.orderByPorSystem(sortDirection);
                    break;
                }
                case "por-instance": {
                    query.orderByPorInstance(sortDirection);
                    break;
                }
                case "por-type": {
                    query.orderByPorType(sortDirection);
                    break;
                }
                case "por-value": {
                    query.orderByPorValue(sortDirection);
                    break;
                }
                case "task-classification-key": {
                    query.orderByTaskClassificationKey(sortDirection);
                    break;
                }
                case "task-classification-category": {
                    query.orderByTaskClassificationCategory(sortDirection);
                    break;
                }
                case "attachment-classification-key": {
                    query.orderByAttachmentClassificationKey(sortDirection);
                    break;
                }
                case "custom-1": {
                    query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_1, sortDirection);
                    break;
                }
                case "custom-2": {
                    query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_2, sortDirection);
                    break;
                }
                case "custom-3": {
                    query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_3, sortDirection);
                    break;
                }
                case "custom-4": {
                    query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_4, sortDirection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning: {}", (Object)query);
        }
    }

    private void applyFilterParams(TaskHistoryQuery query, MultiValueMap<String, String> params) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(query= {}, params= {})", (Object)query, params);
        }
        if (params.containsKey((Object)BUSINESS_PROCESS_ID)) {
            String[] businessProcessId = this.extractCommaSeparatedFields((List)params.get((Object)BUSINESS_PROCESS_ID));
            query.businessProcessIdIn(businessProcessId);
            params.remove((Object)BUSINESS_PROCESS_ID);
        }
        if (params.containsKey((Object)BUSINESS_PROCESS_ID_LIKE)) {
            query.businessProcessIdLike(new String[]{LIKE + (String)((List)params.get((Object)BUSINESS_PROCESS_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)BUSINESS_PROCESS_ID_LIKE);
        }
        if (params.containsKey((Object)PARENT_BUSINESS_PROCESS_ID)) {
            String[] parentBusinessProcessId = this.extractCommaSeparatedFields((List)params.get((Object)PARENT_BUSINESS_PROCESS_ID));
            query.parentBusinessProcessIdIn(parentBusinessProcessId);
            params.remove((Object)PARENT_BUSINESS_PROCESS_ID);
        }
        if (params.containsKey((Object)PARENT_BUSINESS_PROCESS_ID_LIKE)) {
            query.parentBusinessProcessIdLike(new String[]{LIKE + (String)((List)params.get((Object)PARENT_BUSINESS_PROCESS_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)PARENT_BUSINESS_PROCESS_ID_LIKE);
        }
        if (params.containsKey((Object)TASK_ID)) {
            String[] taskId = this.extractCommaSeparatedFields((List)params.get((Object)TASK_ID));
            query.taskIdIn(taskId);
            params.remove((Object)TASK_ID);
        }
        if (params.containsKey((Object)TASK_ID_LIKE)) {
            query.taskIdLike(new String[]{LIKE + (String)((List)params.get((Object)TASK_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)TASK_ID_LIKE);
        }
        if (params.containsKey((Object)EVENT_TYPE)) {
            String[] eventType = this.extractCommaSeparatedFields((List)params.get((Object)EVENT_TYPE));
            query.eventTypeIn(eventType);
            params.remove((Object)EVENT_TYPE);
        }
        if (params.containsKey((Object)EVENT_TYPE_LIKE)) {
            query.eventTypeLike(new String[]{LIKE + (String)((List)params.get((Object)EVENT_TYPE_LIKE)).get(0) + LIKE});
            params.remove((Object)EVENT_TYPE_LIKE);
        }
        if (params.containsKey((Object)CREATED)) {
            String[] created = this.extractCommaSeparatedFields((List)params.get((Object)CREATED));
            TimeInterval timeInterval = this.getTimeIntervalOf(created);
            query.createdWithin(new TimeInterval[]{timeInterval});
            params.remove((Object)CREATED);
        }
        if (params.containsKey((Object)USER_ID)) {
            String[] userId = this.extractCommaSeparatedFields((List)params.get((Object)USER_ID));
            query.userIdIn(userId);
            params.remove((Object)USER_ID);
        }
        if (params.containsKey((Object)USER_ID_LIKE)) {
            query.userIdLike(new String[]{LIKE + (String)((List)params.get((Object)USER_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)USER_ID_LIKE);
        }
        if (params.containsKey((Object)DOMAIN)) {
            query.domainIn(this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN)));
            params.remove((Object)DOMAIN);
        }
        if (params.containsKey((Object)WORKBASKET_KEY)) {
            String[] workbasketKey = this.extractCommaSeparatedFields((List)params.get((Object)WORKBASKET_KEY));
            query.workbasketKeyIn(workbasketKey);
            params.remove((Object)WORKBASKET_KEY);
        }
        if (params.containsKey((Object)WORKBASKET_KEY_LIKE)) {
            query.workbasketKeyLike(new String[]{LIKE + (String)((List)params.get((Object)WORKBASKET_KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)WORKBASKET_KEY_LIKE);
        }
        if (params.containsKey((Object)POR_COMPANY)) {
            String[] porCompany = this.extractCommaSeparatedFields((List)params.get((Object)POR_COMPANY));
            query.porCompanyIn(porCompany);
            params.remove((Object)POR_COMPANY);
        }
        if (params.containsKey((Object)POR_COMPANY_LIKE)) {
            query.porCompanyLike(new String[]{LIKE + (String)((List)params.get((Object)POR_COMPANY_LIKE)).get(0) + LIKE});
            params.remove((Object)POR_COMPANY_LIKE);
        }
        if (params.containsKey((Object)POR_SYSTEM)) {
            String[] porSystem = this.extractCommaSeparatedFields((List)params.get((Object)POR_SYSTEM));
            query.porSystemIn(porSystem);
            params.remove((Object)POR_SYSTEM);
        }
        if (params.containsKey((Object)POR_SYSTEM_LIKE)) {
            query.porSystemLike(new String[]{LIKE + (String)((List)params.get((Object)POR_SYSTEM_LIKE)).get(0) + LIKE});
            params.remove((Object)POR_SYSTEM_LIKE);
        }
        if (params.containsKey((Object)POR_INSTANCE)) {
            String[] porInstance = this.extractCommaSeparatedFields((List)params.get((Object)POR_INSTANCE));
            query.porInstanceIn(porInstance);
            params.remove((Object)POR_INSTANCE);
        }
        if (params.containsKey((Object)POR_INSTANCE_LIKE)) {
            query.porInstanceLike(new String[]{LIKE + (String)((List)params.get((Object)POR_INSTANCE_LIKE)).get(0) + LIKE});
            params.remove((Object)POR_INSTANCE_LIKE);
        }
        if (params.containsKey((Object)POR_TYPE)) {
            String[] porType = this.extractCommaSeparatedFields((List)params.get((Object)POR_TYPE));
            query.porTypeIn(porType);
            params.remove((Object)POR_TYPE);
        }
        if (params.containsKey((Object)POR_TYPE_LIKE)) {
            query.porTypeLike(new String[]{LIKE + (String)((List)params.get((Object)POR_TYPE_LIKE)).get(0) + LIKE});
            params.remove((Object)POR_TYPE_LIKE);
        }
        if (params.containsKey((Object)POR_VALUE)) {
            String[] porValue = this.extractCommaSeparatedFields((List)params.get((Object)POR_VALUE));
            query.porValueIn(porValue);
            params.remove((Object)POR_VALUE);
        }
        if (params.containsKey((Object)POR_VALUE_LIKE)) {
            query.porValueLike(new String[]{LIKE + (String)((List)params.get((Object)POR_VALUE_LIKE)).get(0) + LIKE});
            params.remove((Object)POR_VALUE_LIKE);
        }
        if (params.containsKey((Object)TASK_CLASSIFICATION_KEY)) {
            String[] taskClassificationKey = this.extractCommaSeparatedFields((List)params.get((Object)TASK_CLASSIFICATION_KEY));
            query.taskClassificationKeyIn(taskClassificationKey);
            params.remove((Object)TASK_CLASSIFICATION_KEY);
        }
        if (params.containsKey((Object)TASK_CLASSIFICATION_KEY_LIKE)) {
            query.taskClassificationKeyLike(new String[]{LIKE + (String)((List)params.get((Object)TASK_CLASSIFICATION_KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)TASK_CLASSIFICATION_KEY_LIKE);
        }
        if (params.containsKey((Object)TASK_CLASSIFICATION_CATEGORY)) {
            String[] taskClassificationCategory = this.extractCommaSeparatedFields((List)params.get((Object)TASK_CLASSIFICATION_CATEGORY));
            query.taskClassificationCategoryIn(taskClassificationCategory);
            params.remove((Object)TASK_CLASSIFICATION_CATEGORY);
        }
        if (params.containsKey((Object)TASK_CLASSIFICATION_CATEGORY_LIKE)) {
            query.taskClassificationCategoryLike(new String[]{LIKE + (String)((List)params.get((Object)TASK_CLASSIFICATION_CATEGORY_LIKE)).get(0) + LIKE});
            params.remove((Object)TASK_CLASSIFICATION_CATEGORY_LIKE);
        }
        if (params.containsKey((Object)ATTACHMENT_CLASSIFICATION_KEY)) {
            String[] attachmentClassificationKey = this.extractCommaSeparatedFields((List)params.get((Object)ATTACHMENT_CLASSIFICATION_KEY));
            query.attachmentClassificationKeyIn(attachmentClassificationKey);
            params.remove((Object)ATTACHMENT_CLASSIFICATION_KEY);
        }
        if (params.containsKey((Object)ATTACHMENT_CLASSIFICATION_KEY_LIKE)) {
            query.attachmentClassificationKeyLike(new String[]{LIKE + (String)((List)params.get((Object)ATTACHMENT_CLASSIFICATION_KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)ATTACHMENT_CLASSIFICATION_KEY_LIKE);
        }
        for (TaskHistoryCustomField customField : TaskHistoryCustomField.values()) {
            List list = (List)params.remove((Object)customField.name().replace("_", "-").toLowerCase());
            if (list != null) {
                query.customAttributeIn(customField, this.extractCommaSeparatedFields(list));
            }
            if ((list = (List)params.remove((Object)(customField.name().replace("_", "-").toLowerCase() + "-like"))) == null) continue;
            String[] values = this.extractCommaSeparatedFields(list);
            for (int i = 0; i < values.length; ++i) {
                values[i] = LIKE + values[i] + LIKE;
            }
            query.customAttributeLike(customField, values);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)query);
        }
    }

    private TimeInterval getTimeIntervalOf(String[] created) {
        LocalDate begin;
        try {
            begin = LocalDate.parse(created[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse String '" + created[0] + "'. Expected a String of the Format 'yyyy-MM-dd'.");
        }
        LocalDate end = created.length < 2 ? begin.plusDays(1L) : LocalDate.parse(created[1]);
        Instant beginInst = begin.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant endInst = end.atStartOfDay(ZoneId.systemDefault()).toInstant();
        return new TimeInterval(beginInst, endInst);
    }
}

