/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter;
import pro.taskana.simplehistory.rest.assembler.TaskHistoryEventRepresentationModelAssembler;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventPagedRepresentationModel;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventRepresentationModel;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskHistoryEventController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHistoryEventController.class);
    private final SimpleHistoryServiceImpl simpleHistoryService;
    private final TaskHistoryEventRepresentationModelAssembler assembler;

    @Autowired
    public TaskHistoryEventController(TaskanaEngineConfiguration taskanaEngineConfiguration, SimpleHistoryServiceImpl simpleHistoryServiceImpl, TaskHistoryEventRepresentationModelAssembler assembler) throws SQLException {
        this.simpleHistoryService = simpleHistoryServiceImpl;
        this.simpleHistoryService.initialize(taskanaEngineConfiguration.buildTaskanaEngine());
        this.assembler = assembler;
    }

    @GetMapping(path={"/api/v1/task-history-event"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventPagedRepresentationModel> getTaskHistoryEvents(HttpServletRequest request, TaskHistoryQueryFilterParameter filterParameter, TaskHistoryQuerySortParameter sortParameter, QueryPagingParameter<TaskHistoryEvent, TaskHistoryQuery> pagingParameter) {
        QueryParamsValidator.validateParams((HttpServletRequest)request, (Class[])new Class[]{TaskHistoryQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class});
        TaskHistoryQuery query = this.simpleHistoryService.createTaskHistoryQuery();
        filterParameter.applyToQuery(query);
        sortParameter.applyToQuery((BaseQuery)query);
        List historyEvents = pagingParameter.applyToQuery((BaseQuery)query);
        TaskHistoryEventPagedRepresentationModel pagedResources = (TaskHistoryEventPagedRepresentationModel)this.assembler.toPagedModel(historyEvents, pagingParameter.getPageMetadata());
        ResponseEntity response = ResponseEntity.ok((Object)((Object)pagedResources));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskHistoryEvents(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/task-history-event/{historyEventId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventRepresentationModel> getTaskHistoryEvent(@PathVariable String historyEventId) throws TaskanaHistoryEventNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskHistoryEvent(historyEventId= {})", (Object)historyEventId);
        }
        TaskHistoryEvent resultEvent = this.simpleHistoryService.getTaskHistoryEvent(historyEventId);
        TaskHistoryEventRepresentationModel taskEventResource = this.assembler.toModel(resultEvent);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskHistoryEvent, returning {}", (Object)new ResponseEntity((Object)taskEventResource, HttpStatus.OK));
        }
        return new ResponseEntity((Object)taskEventResource, HttpStatus.OK);
    }

    public static class TaskHistoryQuerySortParameter
    extends QuerySortParameter<TaskHistoryQuery, TaskHistoryQuerySortBy> {
        @ConstructorProperties(value={"sort-by", "order"})
        public TaskHistoryQuerySortParameter(List<TaskHistoryQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        public List<TaskHistoryQuerySortBy> getSortBy() {
            return super.getSortBy();
        }
    }

    public static enum TaskHistoryQuerySortBy implements QuerySortBy<TaskHistoryQuery>
    {
        TASK_HISTORY_EVENT_ID(TaskHistoryQuery::orderByTaskHistoryEventId),
        BUSINESS_PROCESS_ID(TaskHistoryQuery::orderByBusinessProcessId),
        PARENT_BUSINESS_PROCESS_ID(TaskHistoryQuery::orderByParentBusinessProcessId),
        TASK_ID(TaskHistoryQuery::orderByTaskId),
        EVENT_TYPE(TaskHistoryQuery::orderByEventType),
        CREATED(TaskHistoryQuery::orderByCreated),
        USER_ID(TaskHistoryQuery::orderByUserId),
        DOMAIN(TaskHistoryQuery::orderByDomain),
        WORKBASKET_KEY(TaskHistoryQuery::orderByWorkbasketKey),
        POR_COMPANY(TaskHistoryQuery::orderByPorCompany),
        POR_SYSTEM(TaskHistoryQuery::orderByPorSystem),
        POR_INSTANCE(TaskHistoryQuery::orderByPorInstance),
        POR_TYPE(TaskHistoryQuery::orderByPorType),
        POR_VALUE(TaskHistoryQuery::orderByPorValue),
        TASK_CLASSIFICATION_KEY(TaskHistoryQuery::orderByTaskClassificationKey),
        TASK_CLASSIFICATION_CATEGORY(TaskHistoryQuery::orderByTaskClassificationCategory),
        ATTACHMENT_CLASSIFICATION_KEY(TaskHistoryQuery::orderByAttachmentClassificationKey),
        CUSTOM_1((query, sort) -> query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_1, sort)),
        CUSTOM_2((query, sort) -> query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_2, sort)),
        CUSTOM_3((query, sort) -> query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_3, sort)),
        CUSTOM_4((query, sort) -> query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_4, sort));

        private final BiConsumer<TaskHistoryQuery, BaseQuery.SortDirection> consumer;

        private TaskHistoryQuerySortBy(BiConsumer<TaskHistoryQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        public void applySortByForQuery(TaskHistoryQuery query, BaseQuery.SortDirection sortDirection) {
            this.consumer.accept(query, sortDirection);
        }
    }
}

