/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaConfiguration;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter;
import pro.taskana.simplehistory.rest.assembler.TaskHistoryEventRepresentationModelAssembler;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventPagedRepresentationModel;
import pro.taskana.simplehistory.rest.models.TaskHistoryEventRepresentationModel;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskHistoryEventController {
    private final SimpleHistoryServiceImpl simpleHistoryService;
    private final TaskHistoryEventRepresentationModelAssembler assembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public TaskHistoryEventController(TaskanaConfiguration taskanaConfiguration, SimpleHistoryServiceImpl simpleHistoryServiceImpl, TaskHistoryEventRepresentationModelAssembler assembler) throws SQLException {
        this.simpleHistoryService = simpleHistoryServiceImpl;
        this.simpleHistoryService.initialize(TaskanaEngine.buildTaskanaEngine((TaskanaConfiguration)taskanaConfiguration));
        this.assembler = assembler;
    }

    @GetMapping(path={"/api/v1/task-history-event"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventPagedRepresentationModel> getTaskHistoryEvents(HttpServletRequest request, TaskHistoryQueryFilterParameter filterParameter, TaskHistoryQuerySortParameter sortParameter, QueryPagingParameter<TaskHistoryEvent, TaskHistoryQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        TaskHistoryQueryFilterParameter taskHistoryQueryFilterParameter = filterParameter;
        TaskHistoryQuerySortParameter taskHistoryQuerySortParameter = sortParameter;
        QueryPagingParameter<TaskHistoryEvent, TaskHistoryQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, taskHistoryQueryFilterParameter, taskHistoryQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams((HttpServletRequest)request, (Class[])new Class[]{TaskHistoryQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class});
        TaskHistoryQuery query = this.simpleHistoryService.createTaskHistoryQuery();
        filterParameter.apply(query);
        sortParameter.apply((BaseQuery)query);
        List historyEvents = pagingParameter.apply((BaseQuery)query);
        TaskHistoryEventPagedRepresentationModel pagedResources = (TaskHistoryEventPagedRepresentationModel)this.assembler.toPagedModel(historyEvents, pagingParameter.getPageMetadata());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pagedResources)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/task-history-event/{historyEventId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskHistoryEventRepresentationModel> getTaskHistoryEvent(@PathVariable String historyEventId) throws TaskanaHistoryEventNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = historyEventId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskHistoryEvent resultEvent = this.simpleHistoryService.getTaskHistoryEvent(historyEventId);
        TaskHistoryEventRepresentationModel taskEventResource = this.assembler.toModel(resultEvent);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = new ResponseEntity((Object)taskEventResource, (HttpStatusCode)HttpStatus.OK));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskHistoryEventController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskHistoryEventController.java", TaskHistoryEventController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskHistoryEvents", "pro.taskana.simplehistory.rest.TaskHistoryEventController", "jakarta.servlet.http.HttpServletRequest:pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter:pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskHistoryEvent", "pro.taskana.simplehistory.rest.TaskHistoryEventController", "java.lang.String", "historyEventId", "pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException", "org.springframework.http.ResponseEntity"), 101);
    }

    public static final class TaskHistoryQuerySortBy
    extends Enum<TaskHistoryQuerySortBy>
    implements QuerySortBy<TaskHistoryQuery> {
        public static final /* enum */ TaskHistoryQuerySortBy TASK_HISTORY_EVENT_ID;
        public static final /* enum */ TaskHistoryQuerySortBy BUSINESS_PROCESS_ID;
        public static final /* enum */ TaskHistoryQuerySortBy PARENT_BUSINESS_PROCESS_ID;
        public static final /* enum */ TaskHistoryQuerySortBy TASK_ID;
        public static final /* enum */ TaskHistoryQuerySortBy EVENT_TYPE;
        public static final /* enum */ TaskHistoryQuerySortBy CREATED;
        public static final /* enum */ TaskHistoryQuerySortBy USER_ID;
        public static final /* enum */ TaskHistoryQuerySortBy DOMAIN;
        public static final /* enum */ TaskHistoryQuerySortBy WORKBASKET_KEY;
        public static final /* enum */ TaskHistoryQuerySortBy POR_COMPANY;
        public static final /* enum */ TaskHistoryQuerySortBy POR_SYSTEM;
        public static final /* enum */ TaskHistoryQuerySortBy POR_INSTANCE;
        public static final /* enum */ TaskHistoryQuerySortBy POR_TYPE;
        public static final /* enum */ TaskHistoryQuerySortBy POR_VALUE;
        public static final /* enum */ TaskHistoryQuerySortBy TASK_CLASSIFICATION_KEY;
        public static final /* enum */ TaskHistoryQuerySortBy TASK_CLASSIFICATION_CATEGORY;
        public static final /* enum */ TaskHistoryQuerySortBy ATTACHMENT_CLASSIFICATION_KEY;
        public static final /* enum */ TaskHistoryQuerySortBy CUSTOM_1;
        public static final /* enum */ TaskHistoryQuerySortBy CUSTOM_2;
        public static final /* enum */ TaskHistoryQuerySortBy CUSTOM_3;
        public static final /* enum */ TaskHistoryQuerySortBy CUSTOM_4;
        public static final /* enum */ TaskHistoryQuerySortBy OLD_VALUE;
        private final BiConsumer<TaskHistoryQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ TaskHistoryQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            TaskHistoryQuerySortBy.ajc$preClinit();
            TASK_HISTORY_EVENT_ID = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByTaskHistoryEventId);
            BUSINESS_PROCESS_ID = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByBusinessProcessId);
            PARENT_BUSINESS_PROCESS_ID = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByParentBusinessProcessId);
            TASK_ID = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByTaskId);
            EVENT_TYPE = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByEventType);
            CREATED = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByCreated);
            USER_ID = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByUserId);
            DOMAIN = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByDomain);
            WORKBASKET_KEY = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByWorkbasketKey);
            POR_COMPANY = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByPorCompany);
            POR_SYSTEM = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByPorSystem);
            POR_INSTANCE = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByPorInstance);
            POR_TYPE = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByPorType);
            POR_VALUE = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByPorValue);
            TASK_CLASSIFICATION_KEY = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByTaskClassificationKey);
            TASK_CLASSIFICATION_CATEGORY = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByTaskClassificationCategory);
            ATTACHMENT_CLASSIFICATION_KEY = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByAttachmentClassificationKey);
            CUSTOM_1 = new TaskHistoryQuerySortBy((query, sort) -> {
                TaskHistoryQuery taskHistoryQuery = query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_1, sort);
            });
            CUSTOM_2 = new TaskHistoryQuerySortBy((query, sort) -> {
                TaskHistoryQuery taskHistoryQuery = query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_2, sort);
            });
            CUSTOM_3 = new TaskHistoryQuerySortBy((query, sort) -> {
                TaskHistoryQuery taskHistoryQuery = query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_3, sort);
            });
            CUSTOM_4 = new TaskHistoryQuerySortBy((query, sort) -> {
                TaskHistoryQuery taskHistoryQuery = query.orderByCustomAttribute(TaskHistoryCustomField.CUSTOM_4, sort);
            });
            OLD_VALUE = new TaskHistoryQuerySortBy(TaskHistoryQuery::orderByOldValue);
            ENUM$VALUES = new TaskHistoryQuerySortBy[]{TASK_HISTORY_EVENT_ID, BUSINESS_PROCESS_ID, PARENT_BUSINESS_PROCESS_ID, TASK_ID, EVENT_TYPE, CREATED, USER_ID, DOMAIN, WORKBASKET_KEY, POR_COMPANY, POR_SYSTEM, POR_INSTANCE, POR_TYPE, POR_VALUE, TASK_CLASSIFICATION_KEY, TASK_CLASSIFICATION_CATEGORY, ATTACHMENT_CLASSIFICATION_KEY, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, OLD_VALUE};
        }

        private TaskHistoryQuerySortBy(BiConsumer<TaskHistoryQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        public void applySortByForQuery(TaskHistoryQuery query, BaseQuery.SortDirection sortDirection) {
            TaskHistoryQuery taskHistoryQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)taskHistoryQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static TaskHistoryQuerySortBy[] values() {
            TaskHistoryQuerySortBy[] taskHistoryQuerySortByArray;
            TaskHistoryQuerySortBy[] taskHistoryQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskHistoryQuerySortBy[] taskHistoryQuerySortByArray3 = ENUM$VALUES;
            int n = taskHistoryQuerySortByArray3.length;
            TaskHistoryQuerySortBy[] taskHistoryQuerySortByArray4 = new TaskHistoryQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, taskHistoryQuerySortByArray4, 0, n);
            TaskHistoryQuerySortBy[] taskHistoryQuerySortByArray5 = taskHistoryQuerySortByArray2 = (taskHistoryQuerySortByArray = taskHistoryQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryQuerySortByArray2);
            return taskHistoryQuerySortByArray;
        }

        public static TaskHistoryQuerySortBy valueOf(String arg0) {
            TaskHistoryQuerySortBy taskHistoryQuerySortBy;
            TaskHistoryQuerySortBy taskHistoryQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskHistoryQuerySortBy taskHistoryQuerySortBy3 = taskHistoryQuerySortBy2 = (taskHistoryQuerySortBy = Enum.valueOf(TaskHistoryQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskHistoryQuerySortBy2);
            return taskHistoryQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskHistoryEventController.java", TaskHistoryQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortBy", "pro.taskana.simplehistory.impl.task.TaskHistoryQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 140);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortBy", "", "", "", "[Lpro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortBy"), 1);
        }
    }

    public static class TaskHistoryQuerySortParameter
    extends QuerySortParameter<TaskHistoryQuery, TaskHistoryQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public TaskHistoryQuerySortParameter(List<TaskHistoryQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        public List<TaskHistoryQuerySortBy> getSortBy() {
            List list;
            List list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
            return list;
        }

        static {
            TaskHistoryQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskHistoryEventController.java", TaskHistoryQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.simplehistory.rest.TaskHistoryEventController$TaskHistoryQuerySortParameter", "", "", "", "java.util.List"), 159);
        }
    }
}

