/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;

public class TaskHistoryQueryFilterParameter
implements QueryParameter<TaskHistoryQuery, Void> {
    @Schema(name="event-type", description="Filter by the event type of the Task History Event. This is an exact match.")
    @JsonProperty(value="event-type")
    private final String[] eventType;
    @Schema(name="event-type-like", description="Filter by the event type of the Task History Event. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="event-type-like")
    private final String[] eventTypeLike;
    @Schema(name="user-id", description="Filter by the user id of the Task History Event. This is an exact match.")
    @JsonProperty(value="user-id")
    private final String[] userId;
    @Schema(name="user-id-like", description="Filter by the user id of the Task History Event. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="user-id-like")
    private final String[] userIdLike;
    @Schema(name="created", description="Filter by a created time interval. The length of the provided values has to be even. To create an open interval you can either use 'null' or just leave it blank.<p>The format is ISO-8601.")
    private final Instant[] created;
    @Schema(name="domain", description="Filter by the domain of the Task History Event. This is an exact match.")
    private final String[] domain;
    @Schema(name="task-id", description="Filter by the task id of the Task History Event. This is an exact match.")
    @JsonProperty(value="task-id")
    private final String[] taskId;
    @Schema(name="task-id-like", description="Filter by the task id of the Task History Event. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="task-id-like")
    private final String[] taskIdLike;
    @Schema(name="business-process-id", description="Filter by the business process id of the Task History Event. This is an exact match.")
    @JsonProperty(value="business-process-id")
    private final String[] businessProcessId;
    @Schema(name="business-process-id-like", description="Filter by the business process id of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="business-process-id-like")
    private final String[] businessProcessIdLike;
    @Schema(name="parent-business-process-id", description="Filter by the parent business process id of the Task History Event. This is an exact match.")
    @JsonProperty(value="parent-business-process-id")
    private final String[] parentBusinessProcessId;
    @Schema(name="parent-business-process-id-like", description="Filter by the parent business process id of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"Like\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="parent-business-process-id-like")
    private final String[] parentBusinessProcessIdLike;
    @Schema(name="task-classification-key", description="Filter by the task classification key of the Task History Event. This is an exact match.")
    @JsonProperty(value="task-classification-key")
    private final String[] taskClassificationKey;
    @Schema(name="task-classification-key-like", description="Filter by the task classification key of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="task-classification-key-like")
    private final String[] taskClassificationKeyLike;
    @Schema(name="task-classification-category", description="Filter by the task classification category of the Task History Event. This is an exact match.")
    @JsonProperty(value="task-classification-category")
    private final String[] taskClassificationCategory;
    @Schema(name="task-classification-category-like", description="Filter by the task classification category of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"Like\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="task-classification-category-like")
    private final String[] taskClassificationCategoryLike;
    @Schema(name="attachment-classification-key", description="Filter by the attachment classification key of the Task History Event. This is an exact match.")
    @JsonProperty(value="attachment-classification-key")
    private final String[] attachmentClassificationKey;
    @Schema(name="attachment-classification-key-like", description="Filter by the attachment classification key of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"Like\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-classification-key-like")
    private final String[] attachmentClassificationKeyLike;
    @Schema(name="workbasket-key", description="Filter by the workbasket key of the Task History Event. This is an exact match.")
    @JsonProperty(value="workbasket-key")
    private final String[] workbasketKey;
    @Schema(name="workbasket-key-like", description="Filter by the workbasket key of the Task History Event. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="workbasket-key-like")
    private final String[] workbasketKeyLike;
    @Schema(name="por-company", description="* Filter by the company of the primary object reference of the Task History Event. This is an exact match.")
    @JsonProperty(value="por-company")
    private final String[] porCompany;
    @Schema(name="por-company-like", description="Filter by the company of the primary object reference of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-company-like")
    private final String[] porCompanyLike;
    @Schema(name="por-system", description="Filter by the system of the primary object reference of the Task History Event. This is an exact match.")
    @JsonProperty(value="por-system")
    private final String[] porSystem;
    @Schema(name="por-system-like", description="Filter by the system of the primary object reference of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-system-like")
    private final String[] porSystemLike;
    @Schema(name="por-instance", description="Filter by the system instance of the primary object reference of the Task History Event. This is an exact match.")
    @JsonProperty(value="por-instance")
    private final String[] porInstance;
    @Schema(name="por-instance-like", description="Filter by the system instance of the primary object reference of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-instance-like")
    private final String[] porInstanceLike;
    @Schema(name="por-value", description="Filter by the value of the primary object reference of the Task History Event. This is an exact match.")
    @JsonProperty(value="por-value")
    private final String[] porValue;
    @Schema(name="por-value-like", description="Filter by the value of the primary object reference of the Task History Event. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-value-like")
    private final String[] porValueLike;
    @Schema(name="custom-1", description="Filter by the value of the field custom1. This is an exact match.")
    @JsonProperty(value="custom-1")
    private final String[] custom1;
    @Schema(name="custom-1-like", description="Filter by the value of the field custom1. This is an exact match. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-1-like")
    private final String[] custom1Like;
    @Schema(name="custom-2", description="Filter by the value of the field custom2. This is an exact match.")
    @JsonProperty(value="custom-2")
    private final String[] custom2;
    @Schema(name="custom-2-like", description="Filter by the value of the field custom2. This is an exact match. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-2-like")
    private final String[] custom2Like;
    @Schema(name="custom-3", description="Filter by the value of the field custom3. This is an exact match.")
    @JsonProperty(value="custom-3")
    private final String[] custom3;
    @Schema(name="custom-3-like", description="Filter by the value of the field custom3. This is an exact match. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-3-like")
    private final String[] custom3Like;
    @Schema(name="custom-4", description="Filter by the value of the field custom4. This is an exact match.")
    @JsonProperty(value="custom-4")
    private final String[] custom4;
    @Schema(name="custom-4-like", description="Filter by the value of the field custom4. This is an exact match. This results into a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-4-like")
    private final String[] custom4Like;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;

    public String[] getEventType() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.eventType);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getEventTypeLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.eventTypeLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getUserId() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.userId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getUserIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.userIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public Instant[] getCreated() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.created);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public String[] getDomain() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskId() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getBusinessProcessId() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getBusinessProcessIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessId() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskClassificationKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskClassificationKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskClassificationKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskClassificationKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskClassificationCategory() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskClassificationCategory);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskClassificationCategoryLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskClassificationCategoryLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorCompany() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompany);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorCompanyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompanyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystem() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystem);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystemLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystemLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstance() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstance);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstanceLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstanceLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValue() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValue);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValueLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValueLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom1() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom1);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom1Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom1Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom2() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom2);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom2Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom2Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom3() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom3Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom3Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom4() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom4);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom4Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom4Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    @ConstructorProperties(value={"event-type", "event-type-like", "user-id", "user-id-like", "created", "domain", "task-id", "task-id-like", "business-process-id", "business-process-id-like", "parent-business-process-id", "parent-business-process-id-like", "task-classification-key", "task-classification-key-like", "task-classification-category", "task-classification-category-like", "attachment-classification-key", "attachment-classification-key-like", "workbasket-key", "workbasket-key-like", "por-company", "por-company-like", "por-system", "por-system-like", "por-instance", "por-instance-like", "por-value", "por-value-like", "custom-1", "custom-1-like", "custom-2", "custom-2-like", "custom-3", "custom-3-like", "custom-4", "custom-4-like"})
    public TaskHistoryQueryFilterParameter(String[] eventType, String[] eventTypeLike, String[] userId, String[] userIdLike, Instant[] created, String[] domain, String[] taskId, String[] taskIdLike, String[] businessProcessId, String[] businessProcessIdLike, String[] parentBusinessProcessId, String[] parentBusinessProcessIdLike, String[] taskClassificationKey, String[] taskClassificationKeyLike, String[] taskClassificationCategory, String[] taskClassificationCategoryLike, String[] attachmentClassificationKey, String[] attachmentClassificationKeyLike, String[] workbasketKey, String[] workbasketKeyLike, String[] porCompany, String[] porCompanyLike, String[] porSystem, String[] porSystemLike, String[] porInstance, String[] porInstanceLike, String[] porValue, String[] porValueLike, String[] custom1, String[] custom1Like, String[] custom2, String[] custom2Like, String[] custom3, String[] custom3Like, String[] custom4, String[] custom4Like) throws InvalidArgumentException {
        this.eventType = eventType;
        this.eventTypeLike = eventTypeLike;
        this.userId = userId;
        this.userIdLike = userIdLike;
        this.created = created;
        this.domain = domain;
        this.taskId = taskId;
        this.taskIdLike = taskIdLike;
        this.businessProcessId = businessProcessId;
        this.businessProcessIdLike = businessProcessIdLike;
        this.parentBusinessProcessId = parentBusinessProcessId;
        this.parentBusinessProcessIdLike = parentBusinessProcessIdLike;
        this.taskClassificationKey = taskClassificationKey;
        this.taskClassificationKeyLike = taskClassificationKeyLike;
        this.taskClassificationCategory = taskClassificationCategory;
        this.taskClassificationCategoryLike = taskClassificationCategoryLike;
        this.attachmentClassificationKey = attachmentClassificationKey;
        this.attachmentClassificationKeyLike = attachmentClassificationKeyLike;
        this.workbasketKey = workbasketKey;
        this.workbasketKeyLike = workbasketKeyLike;
        this.porCompany = porCompany;
        this.porCompanyLike = porCompanyLike;
        this.porSystem = porSystem;
        this.porSystemLike = porSystemLike;
        this.porInstance = porInstance;
        this.porInstanceLike = porInstanceLike;
        this.porValue = porValue;
        this.porValueLike = porValueLike;
        this.custom1 = custom1;
        this.custom1Like = custom1Like;
        this.custom2 = custom2;
        this.custom2Like = custom2Like;
        this.custom3 = custom3;
        this.custom3Like = custom3Like;
        this.custom4 = custom4;
        this.custom4Like = custom4Like;
        this.validateFilterParameters();
    }

    public Void apply(TaskHistoryQuery query) {
        Void void_;
        TaskHistoryQuery taskHistoryQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)taskHistoryQuery);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional.ofNullable(this.eventType).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.eventTypeIn(stringArray);
        });
        Optional.ofNullable(this.eventTypeLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.eventTypeLike(stringArray);
        });
        Optional.ofNullable(this.userId).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.userIdIn(stringArray);
        });
        Optional.ofNullable(this.userIdLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.userIdLike(stringArray);
        });
        Optional.ofNullable(this.created).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).extractTimeIntervals(arg_0)).ifPresent(timeIntervalArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.createdWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.domain).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.domainIn(stringArray);
        });
        Optional.ofNullable(this.taskId).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskIdIn(stringArray);
        });
        Optional.ofNullable(this.taskIdLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskIdLike(stringArray);
        });
        Optional.ofNullable(this.businessProcessId).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.businessProcessIdIn(stringArray);
        });
        Optional.ofNullable(this.businessProcessIdLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.businessProcessIdLike(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessId).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.parentBusinessProcessIdIn(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessIdLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.parentBusinessProcessIdLike(stringArray);
        });
        Optional.ofNullable(this.taskClassificationKey).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskClassificationKeyIn(stringArray);
        });
        Optional.ofNullable(this.taskClassificationKeyLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskClassificationKeyLike(stringArray);
        });
        Optional.ofNullable(this.taskClassificationCategory).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskClassificationCategoryIn(stringArray);
        });
        Optional.ofNullable(this.taskClassificationCategoryLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.taskClassificationCategoryLike(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKey).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.attachmentClassificationKeyIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKeyLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.attachmentClassificationKeyLike(stringArray);
        });
        Optional.ofNullable(this.workbasketKey).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.workbasketKeyIn(stringArray);
        });
        Optional.ofNullable(this.workbasketKeyLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.workbasketKeyLike(stringArray);
        });
        Optional.ofNullable(this.porCompany).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porCompanyIn(stringArray);
        });
        Optional.ofNullable(this.porCompanyLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porCompanyLike(stringArray);
        });
        Optional.ofNullable(this.porSystem).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porSystemIn(stringArray);
        });
        Optional.ofNullable(this.porSystemLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porSystemLike(stringArray);
        });
        Optional.ofNullable(this.porInstance).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porInstanceIn(stringArray);
        });
        Optional.ofNullable(this.porInstanceLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porInstanceLike(stringArray);
        });
        Optional.ofNullable(this.porValue).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porValueIn(stringArray);
        });
        Optional.ofNullable(this.porValueLike).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(stringArray -> {
            TaskHistoryQuery taskHistoryQuery2 = query.porValueLike(stringArray);
        });
        Optional.ofNullable(this.custom1).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeIn(TaskHistoryCustomField.CUSTOM_1, arr);
        });
        Optional.ofNullable(this.custom1Like).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeLike(TaskHistoryCustomField.CUSTOM_1, arr);
        });
        Optional.ofNullable(this.custom2).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeIn(TaskHistoryCustomField.CUSTOM_2, arr);
        });
        Optional.ofNullable(this.custom2Like).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeLike(TaskHistoryCustomField.CUSTOM_2, arr);
        });
        Optional.ofNullable(this.custom3).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeIn(TaskHistoryCustomField.CUSTOM_3, arr);
        });
        Optional.ofNullable(this.custom3Like).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeLike(TaskHistoryCustomField.CUSTOM_3, arr);
        });
        Optional.ofNullable(this.custom4).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeIn(TaskHistoryCustomField.CUSTOM_4, arr);
        });
        Optional.ofNullable(this.custom4Like).map(arg_0 -> ((TaskHistoryQueryFilterParameter)this).wrapElementsInLikeStatement(arg_0)).ifPresent(arr -> {
            TaskHistoryQuery taskHistoryQuery2 = query.customAttributeLike(TaskHistoryCustomField.CUSTOM_4, arr);
        });
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    private void validateFilterParameters() throws InvalidArgumentException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.created != null && this.created.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'created' is not dividable by 2");
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    static {
        TaskHistoryQueryFilterParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskHistoryQueryFilterParameter.java", TaskHistoryQueryFilterParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEventType", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 15);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEventTypeLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 19);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessId", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 55);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessIdLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 59);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskClassificationKey", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 63);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskClassificationKeyLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 67);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskClassificationCategory", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 71);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskClassificationCategoryLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 75);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKey", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 79);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKeyLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 83);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKey", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 87);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKeyLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserId", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 23);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompany", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 95);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompanyLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 99);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystem", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 103);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystemLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 107);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstance", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 111);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstanceLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 115);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValue", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 119);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValueLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 123);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom1", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 127);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom1Like", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 131);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserIdLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 27);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom2", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 135);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom2Like", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 139);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom3", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 143);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom3Like", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 147);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom4", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 151);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom4Like", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 155);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "pro.taskana.simplehistory.impl.task.TaskHistoryQuery", "query", "", "java.lang.Void"), 567);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateFilterParameters", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 639);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreated", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 31);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 35);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskId", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 39);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskIdLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 43);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessId", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 47);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessIdLike", "pro.taskana.simplehistory.rest.TaskHistoryQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 51);
    }
}

