/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.simplehistory.sampledata;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.configuration.DB;

public class SampleDataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataGenerator.class);
    private static final String TEST_DATA = "/sql.sample-data";
    private static final String CLEAR = "/sql.sample-data/clear-db.sql";
    private static final String HISTORY_EVENT = "/sql.sample-data/history-event.sql";
    DataSource dataSource;
    String dbProductName;

    public SampleDataGenerator(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.dbProductName = connection.getMetaData().getDatabaseProductName();
            if (LOGGER.isTraceEnabled()) {
                String msg = connection.getMetaData().toString();
                LOGGER.trace(msg);
            }
        }
        this.dataSource = dataSource;
    }

    public void generateSampleData(String schemaName) {
        StringWriter outWriter = new StringWriter();
        PrintWriter logWriter = new PrintWriter(outWriter);
        StringWriter errorWriter = new StringWriter();
        PrintWriter errorLogWriter = new PrintWriter(errorWriter);
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner runner = new ScriptRunner(connection);
            runner.runScript((Reader)this.selectSchemaScript(this.dbProductName, schemaName));
            runner.setStopOnError(false);
            runner.runScript((Reader)new BufferedReader(new InputStreamReader(SampleDataGenerator.class.getResourceAsStream(CLEAR), StandardCharsets.UTF_8)));
            runner.setStopOnError(true);
            runner.setLogWriter(logWriter);
            runner.setErrorLogWriter(errorLogWriter);
            runner.runScript((Reader)new BufferedReader(new InputStreamReader(SampleDataGenerator.class.getResourceAsStream(HISTORY_EVENT), StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOGGER.error("caught Exception {}", (Object)e, (Object)e);
        }
        LOGGER.trace(outWriter.toString());
        if (!errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(errorWriter.toString());
        }
    }

    private StringReader selectSchemaScript(String dbProductName, String schemaName) {
        return new StringReader(DB.isPostgreSql((String)dbProductName) ? "SET search_path TO " + schemaName + ";" : "SET SCHEMA " + schemaName + ";");
    }
}

