/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.rest.resource;

import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.server.mvc.RepresentationModelAssemblerSupport;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.simplehistory.impl.HistoryEventImpl;
import pro.taskana.simplehistory.rest.TaskHistoryEventController;
import pro.taskana.simplehistory.rest.resource.TaskHistoryEventResource;
import pro.taskana.spi.history.api.events.TaskanaHistoryEvent;
import pro.taskana.spi.history.api.exceptions.TaskanaHistoryEventNotFoundException;

public class TaskHistoryEventResourceAssembler
extends RepresentationModelAssemblerSupport<TaskanaHistoryEvent, TaskHistoryEventResource> {
    public TaskHistoryEventResourceAssembler() {
        super(HistoryEventImpl.class, TaskHistoryEventResource.class);
    }

    @NonNull
    public TaskHistoryEventResource toModel(@NonNull TaskanaHistoryEvent historyEvent) {
        TaskHistoryEventResource resource = (TaskHistoryEventResource)this.createModelWithId(historyEvent.getId(), historyEvent);
        try {
            resource.removeLinks();
            resource.add(WebMvcLinkBuilder.linkTo(((TaskHistoryEventController)((Object)WebMvcLinkBuilder.methodOn(TaskHistoryEventController.class, (Object[])new Object[0]))).getTaskHistoryEvent(String.valueOf(historyEvent.getId()))).withSelfRel());
        }
        catch (TaskanaHistoryEventNotFoundException e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
        BeanUtils.copyProperties((Object)historyEvent, (Object)((Object)resource));
        if (historyEvent.getCreated() != null) {
            resource.setCreated(historyEvent.getCreated().toString());
        }
        resource.setTaskHistoryId(String.valueOf(historyEvent.getId()));
        return resource;
    }
}

