/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.parselistener;

import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.TaskanaConfigurationProperties;
import pro.taskana.adapter.camunda.parselistener.TaskanaParseListener;
import pro.taskana.adapter.camunda.schemacreator.TaskanaOutboxSchemaCreator;
import pro.taskana.adapter.camunda.util.ReadPropertiesHelper;

public class TaskanaParseListenerProcessEnginePlugin
extends AbstractProcessEnginePlugin
implements TaskanaConfigurationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaParseListenerProcessEnginePlugin.class);

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.initParseListeners(processEngineConfiguration);
        this.initOutbox(processEngineConfiguration);
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    private void initParseListeners(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<TaskanaParseListener> preParseListeners = processEngineConfiguration.getCustomPreBPMNParseListeners();
        if (preParseListeners == null) {
            preParseListeners = new ArrayList<TaskanaParseListener>();
            processEngineConfiguration.setCustomPreBPMNParseListeners(preParseListeners);
        }
        preParseListeners.add(new TaskanaParseListener());
        LOGGER.debug("TaskanaParseListener registered successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOutbox(ProcessEngineConfigurationImpl processEngineConfiguration) {
        boolean processEngineMustBeClosed = false;
        DataSource dataSource = processEngineConfiguration.getDataSource();
        if (dataSource == null) {
            LOGGER.warn("ProcessEngineConfiguration returns null DataSource. Retrieving DataSource from properties.");
            dataSource = this.getDataSourceFromPropertiesFile();
            if (dataSource == null) {
                LOGGER.warn("getDataSourceFromPropertiesFile returns null. Outbox tables must be initialized manually.");
                throw new MissingResourceException("could not retrieve dataSource to initialize the outbox tables.", "TaskanaOutboxSchemaCreator", "TaskanaOutboxSchema");
            }
        } else {
            processEngineMustBeClosed = true;
        }
        try {
            this.createSchema(dataSource);
        }
        finally {
            ProcessEngineImpl processEngine;
            if (processEngineMustBeClosed && (processEngine = processEngineConfiguration.getProcessEngine()) != null) {
                processEngine.close();
            }
        }
        LOGGER.info("TaskanaOutbox initialized successfully");
    }

    private void createSchema(DataSource dataSource) {
        String outboxSchema = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.schema");
        outboxSchema = outboxSchema == null || outboxSchema.isEmpty() ? "taskana_tables" : outboxSchema;
        String createSchemaProperty = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.create_outbox_schema");
        boolean createSchema = true;
        if (createSchemaProperty != null && "false".equals(createSchemaProperty.toLowerCase())) {
            createSchema = false;
        }
        if (createSchema) {
            TaskanaOutboxSchemaCreator schemaCreator = new TaskanaOutboxSchemaCreator(dataSource, outboxSchema);
            try {
                schemaCreator.run();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while trying to initialize the outbox-table", (Throwable)e);
                throw new MissingResourceException("could not initialize the outbox tables.", "TaskanaOutboxSchemaCreator", "TaskanaOutboxSchema");
            }
        }
    }

    private DataSource getDataSourceFromPropertiesFile() {
        DataSource dataSource = null;
        try {
            String jndiLookup = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.jndi");
            if (jndiLookup != null) {
                dataSource = (DataSource)new InitialContext().lookup(jndiLookup);
                if (dataSource != null) {
                    LOGGER.info("retrieved Datasource from jndi lookup {}", (Object)jndiLookup);
                } else {
                    LOGGER.info("jndi lookup {} didn't return a Datasource.", (Object)jndiLookup);
                }
            } else {
                String driver = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.driver");
                String jdbcUrl = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.url");
                String userName = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.username");
                String password = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.password");
                dataSource = TaskanaParseListenerProcessEnginePlugin.createDatasource(driver, jdbcUrl, userName, password);
                LOGGER.info("created Datasource from properties {}, ...", (Object)jdbcUrl);
            }
        }
        catch (NullPointerException | NamingException e) {
            LOGGER.warn("Caught {} while trying to retrieve the datasource from the provided properties file", (Object)e.getClass().getName());
        }
        return dataSource;
    }
}

