/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.schemacreator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskanaOutboxSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaOutboxSchemaCreator.class);
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/taskana-outbox-schema.sql";
    private static final String DB_SCHEMA_DB2 = "/sql/taskana-outbox-schema-db2.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/taskana-outbox-schema-postgres.sql";
    private static final String DB_SCHEMA_ORACLE = "/sql/taskana-outbox-schema-oracle.sql";
    private static final String DB_SCHEMA_DETECTION = "/sql/taskana-outbox-schema-detection.sql";
    private static final String DB_SCHEMA_DETECTION_POSTGRES = "/sql/taskana-outbox-schema-detection-postgres.sql";
    private static final String DB_SCHEMA_DETECTION_ORACLE = "/sql/taskana-outbox-schema-detection-oracle.sql";
    private DataSource dataSource;
    private String schemaName;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public TaskanaOutboxSchemaCreator(DataSource dataSource, String schemaName) {
        this.dataSource = dataSource;
        this.schemaName = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner runner = new ScriptRunner(connection);
            LOGGER.debug(connection.getMetaData().toString());
            runner.setStopOnError(true);
            runner.setLogWriter(this.logWriter);
            runner.setErrorLogWriter(this.errorLogWriter);
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            if (!this.isSchemaPreexisting(connection, databaseProductName)) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(TaskanaOutboxSchemaCreator.selectDbScriptFileName(databaseProductName))));
                runner.runScript((Reader)this.getSqlSchemaNameParsed(reader, databaseProductName));
            }
        }
        finally {
            LOGGER.debug(this.outWriter.toString());
            if (!this.errorWriter.toString().trim().isEmpty()) {
                LOGGER.error(this.errorWriter.toString());
            }
        }
    }

    private ScriptRunner getScriptRunnerInstance(Connection connection) {
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        return runner;
    }

    private boolean isSchemaPreexisting(Connection connection, String databaseProductName) {
        ScriptRunner runner = this.getScriptRunnerInstance(connection);
        StringWriter errorWriter = new StringWriter();
        runner.setErrorLogWriter(new PrintWriter(errorWriter));
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(TaskanaOutboxSchemaCreator.selectDbSchemaDetectionScript(databaseProductName))));
            runner.runScript((Reader)this.getSqlSchemaNameParsed(reader, databaseProductName));
        }
        catch (Exception e) {
            LOGGER.debug("Schema does not exist.");
            e.printStackTrace(System.out);
            if (!errorWriter.toString().trim().isEmpty()) {
                LOGGER.debug(errorWriter.toString());
            }
            return false;
        }
        LOGGER.debug("Schema does exist.");
        return true;
    }

    private static String selectDbSchemaDetectionScript(String dbProductName) {
        if ("PostgreSQL".equals(dbProductName)) {
            return DB_SCHEMA_DETECTION_POSTGRES;
        }
        if (dbProductName != null && dbProductName.toLowerCase().startsWith("oracle")) {
            return DB_SCHEMA_DETECTION_ORACLE;
        }
        return DB_SCHEMA_DETECTION;
    }

    private static String selectDbScriptFileName(String dbProductName) {
        if ("PostgreSQL".equals(dbProductName)) {
            return DB_SCHEMA_POSTGRES;
        }
        if ("H2".equals(dbProductName)) {
            return DB_SCHEMA;
        }
        if (dbProductName != null && dbProductName.toLowerCase().startsWith("oracle")) {
            return DB_SCHEMA_ORACLE;
        }
        return DB_SCHEMA_DB2;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader, String dbProductName) {
        boolean isPostGres = "PostgreSQL".equals(dbProductName);
        StringBuffer content = new StringBuffer();
        String effectiveSchemaName = isPostGres ? this.schemaName.toLowerCase() : this.schemaName.toUpperCase();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replaceAll("%schemaName%", effectiveSchemaName) + System.lineSeparator());
            }
        }
        catch (IOException e) {
            LOGGER.error("SchemaName sql parsing failed for schemaName {}. Caught {}", (Object)effectiveSchemaName, (Object)e);
        }
        return new StringReader(content.toString());
    }
}

