/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.tasklistener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.TaskanaConfigurationProperties;
import pro.taskana.adapter.camunda.dto.ReferencedTask;
import pro.taskana.adapter.camunda.dto.VariableValueDto;
import pro.taskana.adapter.camunda.mapper.JacksonConfigurator;
import pro.taskana.adapter.camunda.util.PrimitiveWrapperChecker;
import pro.taskana.adapter.camunda.util.ReadPropertiesHelper;

public class TaskanaTaskListener
implements TaskListener,
TaskanaConfigurationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaTaskListener.class);
    private static final String TASK_STATE_COMPLETED = "COMPLETED";
    private static final String TASK_STATE_CANCELLED = "CANCELLED";
    private static final String TASK_STATE_TERMINATED = "TERMINATED";
    private static final String DEFAULT_SCHEMA = "taskana_tables";
    private static final String SQL_INSERT_EVENT = "INSERT INTO event_store (TYPE,CREATED,PAYLOAD) VALUES (?,?,?)";
    private static TaskanaTaskListener instance = null;
    private boolean gotActivated = false;
    private ObjectMapper objectMapper = JacksonConfigurator.createAndConfigureObjectMapper();
    private String outboxSchemaName = null;

    public static TaskanaTaskListener getInstance() {
        if (instance == null) {
            instance = new TaskanaTaskListener();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notify(DelegateTask delegateTask) {
        try (Connection connection = Context.getProcessEngineConfiguration().getDataSource().getConnection();){
            if (!this.gotActivated) {
                this.gotActivated = true;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("TaskanaTaskListener activated successfully, connected to %s", connection.getMetaData().getURL()));
                }
            }
            switch (delegateTask.getEventName()) {
                case "create": {
                    this.insertCreateEventIntoOutbox(delegateTask, connection);
                    return;
                }
                case "complete": 
                case "delete": {
                    this.insertCompleteOrDeleteEventIntoOutbox(delegateTask, connection);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to process a delegate task", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCreateEventIntoOutbox(DelegateTask delegateTask, Connection connection) throws SQLException {
        String camundaSchema = null;
        try {
            camundaSchema = connection.getSchema();
            LOGGER.debug("camundaSchema in taskListener is {}", (Object)camundaSchema);
            String referencedTaskJson = this.getReferencedTaskJson(delegateTask);
            this.setOutboxSchema(connection);
            this.prepareAndExecuteStatement(connection, delegateTask, referencedTaskJson);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Caught JsonProcessingException while trying to convert ReferencedTask to JSON-String");
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to insert a \"create\" event into the outbox table", (Throwable)e);
        }
        finally {
            if (camundaSchema != null) {
                connection.setSchema(camundaSchema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertCompleteOrDeleteEventIntoOutbox(DelegateTask delegateTask, Connection connection) throws SQLException {
        if (delegateTask.getEventName().equals("complete") && this.taskWasCompletedByTaskanaAdapter(delegateTask)) {
            return;
        }
        String camundaSchema = null;
        try {
            String taskState = TASK_STATE_COMPLETED;
            if (delegateTask.getEventName().equals("delete")) {
                taskState = delegateTask.getExecution().isCanceled() ? TASK_STATE_CANCELLED : TASK_STATE_TERMINATED;
            }
            String payload = String.format("{\"id\":\"%s\",\"taskState\":\"%s\"}", delegateTask.getId(), taskState);
            camundaSchema = connection.getSchema();
            this.setOutboxSchema(connection);
            this.prepareAndExecuteStatement(connection, delegateTask, payload);
            connection.setSchema(camundaSchema);
            if (camundaSchema == null) return;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Caught exception while trying to insert a %s event into the outbox table", delegateTask.getEventName()), (Throwable)e);
            return;
        }
        finally {
            if (camundaSchema != null) {
                connection.setSchema(camundaSchema);
            }
        }
        connection.setSchema(camundaSchema);
        return;
    }

    private boolean taskWasCompletedByTaskanaAdapter(DelegateTask delegateTask) {
        return delegateTask.getVariableNamesLocal().contains("completedByTaskanaAdapter");
    }

    private void setOutboxSchema(Connection connection) throws SQLException {
        if (this.outboxSchemaName == null) {
            this.outboxSchemaName = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.schema");
        }
        this.outboxSchemaName = this.outboxSchemaName == null || this.outboxSchemaName.isEmpty() ? DEFAULT_SCHEMA : this.outboxSchemaName;
        String dbProductName = connection.getMetaData().getDatabaseProductName();
        if ("PostgreSQL".equals(dbProductName)) {
            connection.setSchema(this.outboxSchemaName.toLowerCase());
        } else {
            connection.setSchema(this.outboxSchemaName.toUpperCase());
        }
    }

    private void prepareAndExecuteStatement(Connection connection, DelegateTask delegateTask, String payloadJson) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(SQL_INSERT_EVENT, 1);){
            Timestamp eventCreationTimestamp = Timestamp.from(Instant.now());
            preparedStatement.setString(1, delegateTask.getEventName());
            preparedStatement.setTimestamp(2, eventCreationTimestamp);
            preparedStatement.setString(3, payloadJson);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to prepare and execute statement", (Throwable)e);
        }
    }

    private String getReferencedTaskJson(DelegateTask delegateTask) throws JsonProcessingException {
        ReferencedTask referencedTask = new ReferencedTask();
        referencedTask.setId(delegateTask.getId());
        referencedTask.setCreated(this.formatDate(delegateTask.getCreateTime()));
        referencedTask.setPriority(String.valueOf(delegateTask.getPriority()));
        referencedTask.setName(delegateTask.getName());
        referencedTask.setAssignee(delegateTask.getAssignee());
        referencedTask.setDue(this.formatDate(delegateTask.getDueDate()));
        referencedTask.setDescription(delegateTask.getDescription());
        referencedTask.setOwner(delegateTask.getOwner());
        referencedTask.setTaskDefinitionKey(delegateTask.getTaskDefinitionKey());
        referencedTask.setBusinessProcessId(delegateTask.getProcessInstanceId());
        referencedTask.setClassificationKey(this.getUserTaskExtensionProperty(delegateTask, "taskana.classification-key"));
        referencedTask.setDomain(this.getProcessModelExtensionProperty(delegateTask, "taskana.domain"));
        referencedTask.setWorkbasketKey(this.getWorkbasketKey(delegateTask));
        referencedTask.setVariables(this.getProcessVariables(delegateTask));
        String referencedTaskJson = this.objectMapper.writeValueAsString((Object)referencedTask);
        LOGGER.debug("Exit from getReferencedTaskJson. Returning {}.", (Object)referencedTaskJson);
        return referencedTaskJson;
    }

    private String getProcessVariables(DelegateTask delegateTask) {
        StringBuilder processVariablesBuilder = new StringBuilder();
        String processVariablesConcatenated = this.getProcessModelExtensionProperty(delegateTask, "taskana-attributes");
        if (processVariablesConcatenated != null) {
            List<String> processVariablenames = this.splitProcessVariableNamesString(processVariablesConcatenated);
            processVariablenames.forEach(nameOfProcessVariableToAdd -> this.addToProcessVariablesBuilder(delegateTask, this.objectMapper, processVariablesBuilder, (String)nameOfProcessVariableToAdd));
            if (processVariablesBuilder.length() <= 0) {
                return "{}";
            }
        } else {
            return "{}";
        }
        processVariablesBuilder.deleteCharAt(processVariablesBuilder.length() - 1).append("}");
        processVariablesBuilder.insert(0, "{");
        return processVariablesBuilder.toString();
    }

    private void addToProcessVariablesBuilder(DelegateTask delegateTask, ObjectMapper objectMapper, StringBuilder processVariablesBuilder, String nameOfprocessVariableToAdd) {
        Object processVariable = delegateTask.getVariable(nameOfprocessVariableToAdd);
        if (processVariable != null) {
            try {
                VariableValueDto variableValueDto = this.determineProcessVariableTypeAndCreateVariableValueDto(processVariable, objectMapper);
                String variableValueDtoJson = objectMapper.writeValueAsString((Object)variableValueDto);
                processVariablesBuilder.append("\"").append(nameOfprocessVariableToAdd).append("\":").append(variableValueDtoJson).append(",");
            }
            catch (Exception ex) {
                LOGGER.warn("Caught exception while trying to create JSON-String out of process variable object", (Throwable)ex);
            }
        }
    }

    private VariableValueDto determineProcessVariableTypeAndCreateVariableValueDto(Object processVariable, ObjectMapper objectMapper) throws JsonProcessingException {
        VariableValueDto variableValueDto = new VariableValueDto();
        String type = "Object";
        HashMap<String, Object> valueInfo = new HashMap<String, Object>();
        valueInfo.put("objectTypeName", processVariable.getClass());
        if (processVariable.getClass().isPrimitive() || PrimitiveWrapperChecker.isPrimitiveWrapper(processVariable.getClass()) && !processVariable.getClass().getTypeName().equals("String")) {
            type = processVariable.getClass().getSimpleName();
            variableValueDto.setType(type);
            variableValueDto.setValue(processVariable);
            variableValueDto.setValueInfo(valueInfo);
        } else {
            String processVariableJsonString = objectMapper.writeValueAsString(processVariable);
            valueInfo.put("serializationDataFormat", "application/json");
            variableValueDto.setType(type);
            variableValueDto.setValue(processVariableJsonString);
            variableValueDto.setValueInfo(valueInfo);
        }
        return variableValueDto;
    }

    private List<String> splitProcessVariableNamesString(String processVariableNamesConcatenated) {
        return Arrays.asList(processVariableNamesConcatenated.trim().split("\\s*,\\s*"));
    }

    private String getWorkbasketKey(DelegateTask delegateTask) {
        String workbasketKey = null;
        try {
            Object workbasketKeyObj = delegateTask.getVariable("taskana.workbasket-key");
            if (workbasketKeyObj instanceof String) {
                workbasketKey = (String)workbasketKeyObj;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to retrieve taskana.workbasket-key for task {} in ProcessDefinition {}", new Object[]{delegateTask.getName(), delegateTask.getProcessDefinitionId(), e});
        }
        return workbasketKey;
    }

    private String getProcessModelExtensionProperty(DelegateTask delegateTask, String propertyKey) {
        String propertyValue = null;
        BpmnModelInstance model = delegateTask.getExecution().getBpmnModelInstance();
        try {
            List processModelExtensionProperties = model.getModelElementsByType(CamundaProperty.class).stream().filter(camundaProperty -> camundaProperty.getCamundaName().equals(propertyKey)).collect(Collectors.toList());
            if (processModelExtensionProperties.isEmpty()) {
                return propertyValue;
            }
            propertyValue = ((CamundaProperty)processModelExtensionProperties.get(0)).getCamundaValue();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Caught exception while trying to retrieve the %s property from process model %s", propertyKey, model.getDefinitions().getName()), (Throwable)e);
        }
        return propertyValue;
    }

    private String getUserTaskExtensionProperty(DelegateTask delegateTask, String propertyKey) {
        String propertyValue = null;
        try {
            ExtensionElements extensionElements = delegateTask.getExecution().getBpmnModelElementInstance().getExtensionElements();
            if (extensionElements == null) {
                return propertyValue;
            }
            CamundaProperties camundaProperties = (CamundaProperties)extensionElements.getElementsQuery().filterByType(CamundaProperties.class).singleResult();
            List userTaskExtensionProperties = camundaProperties.getCamundaProperties().stream().filter(camundaProperty -> camundaProperty.getCamundaName().equals(propertyKey)).collect(Collectors.toList());
            if (userTaskExtensionProperties.isEmpty()) {
                return propertyValue;
            }
            propertyValue = ((CamundaProperty)userTaskExtensionProperties.get(0)).getCamundaValue();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to retrieve the {} property of user task {}", new Object[]{propertyKey, delegateTask.getName(), e});
        }
        return propertyValue;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault()).format(date.toInstant());
    }
}

