/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.parselistener;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.TaskanaConfigurationProperties;
import pro.taskana.adapter.camunda.exceptions.SystemException;
import pro.taskana.adapter.camunda.parselistener.TaskanaParseListener;
import pro.taskana.adapter.camunda.schemacreator.DB;
import pro.taskana.adapter.camunda.schemacreator.TaskanaOutboxSchemaCreator;
import pro.taskana.adapter.camunda.util.ReadPropertiesHelper;

public class TaskanaParseListenerProcessEnginePlugin
extends AbstractProcessEnginePlugin
implements TaskanaConfigurationProperties {
    private static final String OUTBOX_SCHEMA_VERSION = "0.0.1";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaParseListenerProcessEnginePlugin.class);

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.initParseListeners(processEngineConfiguration);
        this.initOutbox(processEngineConfiguration);
    }

    private void initParseListeners(ProcessEngineConfigurationImpl processEngineConfiguration) {
        try {
            ArrayList<TaskanaParseListener> preParseListeners = processEngineConfiguration.getCustomPreBPMNParseListeners();
            if (preParseListeners == null) {
                preParseListeners = new ArrayList<TaskanaParseListener>();
                processEngineConfiguration.setCustomPreBPMNParseListeners(preParseListeners);
            }
            preParseListeners.add(new TaskanaParseListener());
            LOGGER.debug("TaskanaParseListener registered successfully");
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to register TaskanaParseListener", (Throwable)e);
            throw new SystemException("An error occured while trying to register the TaskanaParseListener. Aborting the boot of camunda.");
        }
    }

    private void initOutbox(ProcessEngineConfigurationImpl processEngineConfiguration) {
        DataSource camundaDataSource = this.retrieveCamundaDatasource(processEngineConfiguration);
        this.createSchema(camundaDataSource);
        LOGGER.info("TaskanaOutbox initialized successfully");
    }

    private void createSchema(DataSource camundaDataSource) {
        String outboxSchema = this.initSchemaName(camundaDataSource);
        TaskanaOutboxSchemaCreator schemaCreator = new TaskanaOutboxSchemaCreator(camundaDataSource, outboxSchema);
        boolean isSchemaPreexisting = schemaCreator.isSchemaPreexisting();
        boolean shouldSchemaBeCreated = this.isAutomatedSchemaCreationEnabled();
        if (!isSchemaPreexisting && shouldSchemaBeCreated) {
            LOGGER.debug("Running scripts to create schema and tables for TaskanaOutbox");
            if (!schemaCreator.createSchema()) {
                LOGGER.warn("An error occured while trying to automatically create the TaskanaOutbox schema and table. Aborting the boot of camunda.");
                throw new SystemException("An error occured while trying to automatically create the TaskanaOutbox schema and table. Aborting the boot of camunda.");
            }
        }
        if (!schemaCreator.isValidSchemaVersion(OUTBOX_SCHEMA_VERSION)) {
            LOGGER.warn("Aborting start up of camunda. Please migrate to the newest version of the TaskanaOutbox schema");
            throw new SystemException("The Database Schema Version doesn't match the expected version 0.0.1. Aborting the boot of camunda.");
        }
    }

    private boolean isAutomatedSchemaCreationEnabled() {
        boolean createSchema = true;
        String createSchemaProperty = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.create_outbox_schema");
        if (createSchemaProperty != null && "false".equalsIgnoreCase(createSchemaProperty)) {
            createSchema = false;
        }
        return createSchema;
    }

    private String initSchemaName(DataSource dataSource) {
        String outboxSchema = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.schema");
        outboxSchema = outboxSchema == null || outboxSchema.isEmpty() ? "taskana_tables" : outboxSchema;
        try (Connection connection = dataSource.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            outboxSchema = DB.isPostgreSql(databaseProductName) ? outboxSchema.toLowerCase() : outboxSchema.toUpperCase();
        }
        catch (SQLException ex) {
            LOGGER.error("Caught exception when attempting to initialize the schema name", (Throwable)ex);
        }
        LOGGER.debug("Using schema name {}", (Object)outboxSchema);
        return outboxSchema;
    }

    private DataSource retrieveCamundaDatasource(ProcessEngineConfigurationImpl processEngineConfiguration) {
        DataSource dataSource = processEngineConfiguration.getDataSource();
        if (dataSource == null) {
            LOGGER.warn("ProcessEngineConfiguration returns null DataSource. Retrieving DataSource from properties.");
            dataSource = this.getDataSourceFromPropertiesFile();
            if (dataSource == null) {
                LOGGER.warn("getDataSourceFromPropertiesFile returns null. Outbox tables must be initialized manually.");
                throw new MissingResourceException("could not retrieve dataSource to initialize the outbox tables.", "TaskanaOutboxSchemaCreator", "TaskanaOutboxSchema");
            }
        }
        return dataSource;
    }

    private DataSource getDataSourceFromPropertiesFile() {
        DataSource dataSource = null;
        try {
            String jndiLookup = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.jndi");
            if (jndiLookup != null) {
                dataSource = (DataSource)new InitialContext().lookup(jndiLookup);
                if (dataSource != null) {
                    LOGGER.info("retrieved Datasource from jndi lookup {}", (Object)jndiLookup);
                } else {
                    LOGGER.info("jndi lookup {} didn't return a Datasource.", (Object)jndiLookup);
                }
            } else {
                String driver = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.driver");
                String jdbcUrl = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.url");
                String userName = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.username");
                String password = ReadPropertiesHelper.getPropertyValueFromFile("taskana-outbox.properties", "taskana.adapter.outbox.datasource.password");
                dataSource = TaskanaParseListenerProcessEnginePlugin.createDatasource(driver, jdbcUrl, userName, password);
                LOGGER.info("created Datasource from properties {}, ...", (Object)jdbcUrl);
            }
        }
        catch (NullPointerException | NamingException e) {
            LOGGER.warn("Caught {} while trying to retrieve the datasource from the provided properties file", (Object)e.getClass().getName());
        }
        return dataSource;
    }

    private static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }
}

