/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.schemacreator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskanaOutboxSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaOutboxSchemaCreator.class);
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String H2 = "H2";
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/h2/taskana-outbox-schema.sql";
    private static final String DB_SCHEMA_DB2 = "/sql/db2/taskana-outbox-schema-db2.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/postgres/taskana-outbox-schema-postgres.sql";
    private static final String DB_SCHEMA_ORACLE = "/sql/oracle/taskana-outbox-schema-oracle.sql";
    private DataSource dataSource;
    private String schemaName;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public TaskanaOutboxSchemaCreator(DataSource dataSource, String schemaName) {
        this.dataSource = dataSource;
        this.schemaName = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSchema() {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner runner = new ScriptRunner(connection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(connection.getMetaData().toString());
            }
            runner.setStopOnError(true);
            runner.setLogWriter(this.logWriter);
            runner.setErrorLogWriter(this.errorLogWriter);
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(TaskanaOutboxSchemaCreator.selectDbScriptFileName(databaseProductName))));
            runner.runScript((Reader)this.getSqlSchemaNameParsed(reader, databaseProductName));
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.outWriter.toString());
            }
            if (!this.errorWriter.toString().trim().isEmpty() && LOGGER.isErrorEnabled()) {
                LOGGER.error(this.errorWriter.toString());
            }
        }
        LOGGER.info("TaskanaOutbox schema created successfully");
        return true;
    }

    public boolean isSchemaPreexisting() {
        try {
            Map<String, Object> queryResult = this.querySchema();
            if (queryResult == null || queryResult.isEmpty()) {
                LOGGER.error("TaskanaOutbox does not exist");
                return false;
            }
            LOGGER.debug("TaskanaOutbox does exist.");
            return true;
        }
        catch (SQLException | RuntimeSqlException e) {
            LOGGER.error("TaskanaOutbox schema doesn't exist");
            return false;
        }
    }

    public boolean isValidSchemaVersion(String expectedOutboxSchemaVersion) {
        try {
            Map<String, Object> queryResult = this.querySchema();
            if (queryResult == null || queryResult.isEmpty()) {
                LOGGER.error("Schema version not valid. The VERSION property in table OUTBOX_SCHEMA_VERSION has not the expected value {}", (Object)expectedOutboxSchemaVersion);
                return false;
            }
            if (queryResult.get("VERSION").equals(expectedOutboxSchemaVersion)) {
                LOGGER.debug("Schema version is valid.");
                return true;
            }
        }
        catch (SQLException | RuntimeSqlException e) {
            LOGGER.error("Schema version not valid. The VERSION property in table OUTBOX_SCHEMA_VERSION has not the expected value {}", (Object)expectedOutboxSchemaVersion);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> querySchema() throws SQLException {
        Throwable throwable = null;
        try (Connection connection = this.dataSource.getConnection();){
            Map map;
            String originalSchema = connection.getSchema();
            connection.setSchema(this.schemaName);
            SqlRunner runner = new SqlRunner(connection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(connection.getMetaData().toString());
            }
            String query = "select VERSION from OUTBOX_SCHEMA_VERSION where VERSION = (select max(VERSION) from OUTBOX_SCHEMA_VERSION) ";
            try {
                Map queryResult = runner.selectOne(query, new Object[0]);
                connection.setSchema(originalSchema);
                map = queryResult;
            }
            catch (Throwable throwable2) {
                try {
                    connection.setSchema(originalSchema);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            connection.setSchema(originalSchema);
            return map;
        }
    }

    private static String selectDbScriptFileName(String dbProductName) {
        if (POSTGRESQL.equals(dbProductName)) {
            return DB_SCHEMA_POSTGRES;
        }
        if (H2.equals(dbProductName)) {
            return DB_SCHEMA;
        }
        if (dbProductName != null && dbProductName.toLowerCase().startsWith("oracle")) {
            return DB_SCHEMA_ORACLE;
        }
        return DB_SCHEMA_DB2;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader, String dbProductName) {
        boolean isPostGres = POSTGRESQL.equals(dbProductName);
        StringBuilder content = new StringBuilder();
        String effectiveSchemaName = isPostGres ? this.schemaName.toLowerCase() : this.schemaName.toUpperCase();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replace("%schemaName%", effectiveSchemaName)).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            LOGGER.error("SchemaName sql parsing failed for schemaName {}. Caught exception", (Object)effectiveSchemaName, (Object)e);
        }
        return new StringReader(content.toString());
    }
}

