/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.outbox.rest.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEvent;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class CamundaTaskEventsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaTaskEventsService.class);
    private static String outboxSchema = CamundaTaskEventsService.getSchemaFromProperties();
    private static final String SQL_GET_CREATE_EVENTS = "SELECT * FROM " + outboxSchema + ".event_store WHERE type = ?";
    private static final String SQL_GET_COMPLETE_AND_DELETE_EVENTS = "SELECT * FROM " + outboxSchema + ".event_store WHERE type = ? OR type = ?";
    private static final String SQL_WITHOUT_PLACEHOLDERS_DELETE_EVENTS = "DELETE FROM " + outboxSchema + ".event_store WHERE id in (%s)";
    private DataSource dataSource = null;

    public List<CamundaTaskEvent> getEvents(List<String> requestedEventTypes) {
        List camundaTaskEvents = new ArrayList();
        if (requestedEventTypes.contains("create")) {
            camundaTaskEvents = this.getCreateEvents();
        } else if (requestedEventTypes.contains("delete") && requestedEventTypes.contains("complete")) {
            camundaTaskEvents = this.getCompleteAndDeleteEvents();
        }
        return camundaTaskEvents;
    }

    public void deleteEvents(String idsAsJsonArray) {
        List idsAsIntegers = this.getIdsAsIntegers(idsAsJsonArray);
        String deleteEventsSqlWithPlaceholders = String.format(SQL_WITHOUT_PLACEHOLDERS_DELETE_EVENTS, this.preparePlaceHolders(idsAsIntegers.size()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(deleteEventsSqlWithPlaceholders);){
            this.setPreparedStatementValues(preparedStatement, idsAsIntegers);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught {} while trying to delete events from the outbox table", (Throwable)e);
        }
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    private List<CamundaTaskEvent> getCreateEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = this.getPreparedCreateEventsStatement(connection);){
            ResultSet camundaTaskEventResultSet = preparedStatement.executeQuery();
            camundaTaskEvents = this.getCamundaTaskEvents(camundaTaskEventResultSet);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve create events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private String preparePlaceHolders(int length) {
        return String.join((CharSequence)",", Collections.nCopies(length, "?"));
    }

    private void setPreparedStatementValues(PreparedStatement preparedStatement, List<Integer> ids) throws SQLException {
        for (int i = 0; i < ids.size(); ++i) {
            preparedStatement.setObject(i + 1, ids.get(i));
        }
    }

    private List<CamundaTaskEvent> getCamundaTaskEvents(ResultSet createEventsResultSet) throws SQLException {
        ArrayList<CamundaTaskEvent> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        while (createEventsResultSet.next()) {
            CamundaTaskEvent camundaTaskEvent = new CamundaTaskEvent();
            camundaTaskEvent.setId(createEventsResultSet.getInt(1));
            camundaTaskEvent.setType(createEventsResultSet.getString(2));
            camundaTaskEvent.setCreated(this.formatDate((Date)createEventsResultSet.getTimestamp(3)));
            camundaTaskEvent.setPayload(createEventsResultSet.getString(4));
            camundaTaskEvents.add(camundaTaskEvent);
        }
        return camundaTaskEvents;
    }

    private List<Integer> getIdsAsIntegers(String idsAsJsonArray) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Integer> idsAsIntegers = new ArrayList<Integer>();
        try {
            JsonNode idsAsJsonArrayNode = objectMapper.readTree(idsAsJsonArray).get("taskCreationIds");
            if (idsAsJsonArrayNode != null) {
                idsAsJsonArrayNode.forEach(id -> idsAsIntegers.add(id.asInt()));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Caught {} while trying to read the passed JSON-Object in the POST-Request to delete events from the outbox table", (Throwable)e);
        }
        return idsAsIntegers;
    }

    private PreparedStatement getPreparedCreateEventsStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(SQL_GET_CREATE_EVENTS);
        preparedStatement.setString(1, "create");
        return preparedStatement;
    }

    private List<CamundaTaskEvent> getCompleteAndDeleteEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = this.getPreparedCompleteAndDeleteEventsStatement(connection);){
            ResultSet completeAndDeleteEventsResultSet = preparedStatement.executeQuery();
            camundaTaskEvents = this.getCamundaTaskEvents(completeAndDeleteEventsResultSet);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve complete/delete events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private PreparedStatement getPreparedCompleteAndDeleteEventsStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(SQL_GET_COMPLETE_AND_DELETE_EVENTS);
        preparedStatement.setString(1, "complete");
        preparedStatement.setString(2, "delete");
        return preparedStatement;
    }

    private Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve a connection from the provided datasource", (Throwable)e);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() {
        Class<CamundaTaskEventsService> clazz = CamundaTaskEventsService.class;
        synchronized (CamundaTaskEventsService.class) {
            if (this.dataSource == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.getDataSourceFromPropertiesFile();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataSource;
        }
    }

    private DataSource getDataSourceFromPropertiesFile() {
        InputStream datasourceConfig = CamundaTaskEventsService.class.getClassLoader().getResourceAsStream("taskana-outbox.properties");
        Properties properties = new Properties();
        try {
            properties.load(datasourceConfig);
            String jndiUrl = properties.getProperty("taskana.adapter.outbox.rest.datasource.jndi");
            this.dataSource = jndiUrl != null ? (DataSource)new InitialContext().lookup(jndiUrl) : CamundaTaskEventsService.createDatasource((String)properties.getProperty("taskana.adapter.outbox.rest.datasource.driver"), (String)properties.getProperty("taskana.adapter.outbox.rest.datasource.url"), (String)properties.getProperty("taskana.adapter.outbox.rest.datasource.username"), (String)properties.getProperty("taskana.adapter.outbox.rest.datasource.password"));
        }
        catch (IOException | NullPointerException | NamingException e) {
            LOGGER.warn("Caught {} while trying to retrieve the datasource from the provided properties file", (Throwable)e);
        }
        return this.dataSource;
    }

    private static String getSchemaFromProperties() {
        String defaultSchema = "taskana_tables";
        InputStream propertiesStream = CamundaTaskEventsService.class.getClassLoader().getResourceAsStream("taskana-outbox.properties");
        Properties properties = new Properties();
        String outboxSchema = null;
        try {
            properties.load(propertiesStream);
            outboxSchema = properties.getProperty("taskana.outbox.schema");
        }
        catch (IOException | NullPointerException e) {
            LOGGER.warn("Caught {} while trying to retrieve the outbox-schema from the provided properties file.");
        }
        outboxSchema = outboxSchema == null || outboxSchema.isEmpty() ? defaultSchema : outboxSchema;
        return outboxSchema;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault()).format(date.toInstant());
    }
}

