/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.outbox.rest.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.TaskanaConfigurationProperties;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEvent;
import pro.taskana.common.api.exceptions.SystemException;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class CamundaTaskEventsService
implements TaskanaConfigurationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaTaskEventsService.class);
    private static final String CREATE = "create";
    private static final String COMPLETE = "complete";
    private static final String DELETE = "delete";
    private static final String OUTBOX_SCHEMA = CamundaTaskEventsService.getSchemaFromProperties();
    private static final String SQL_GET_CREATE_EVENTS = "select * from %s.event_store where type = ? fetch first %d rows only";
    private static final String SQL_GET_COMPLETE_AND_DELETE_EVENTS = "select * from %s.event_store where type = ? OR type = ? fetch first %d rows only";
    private static final String SQL_WITHOUT_PLACEHOLDERS_DELETE_EVENTS = "delete from %s.event_store where id in (%s)";
    private static final int MAX_NUMBER_OF_EVENTS_DEFAULT = 50;
    private static Properties outboxProperties;
    private static int maxNumberOfEventsReturned;
    private DataSource dataSource = null;

    public List<CamundaTaskEvent> getEvents(List<String> requestedEventTypes) {
        List camundaTaskEvents = new ArrayList();
        if (requestedEventTypes.contains("create")) {
            camundaTaskEvents = this.getCreateEvents();
        } else if (requestedEventTypes.contains("delete") && requestedEventTypes.contains("complete")) {
            camundaTaskEvents = this.getCompleteAndDeleteEvents();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("outbox retrieved {} camundaTaskEvents: {}", (Object)camundaTaskEvents.size(), (Object)camundaTaskEvents.stream().map(Object::toString).collect(Collectors.joining(";\n")));
        }
        return camundaTaskEvents;
    }

    public void deleteEvents(String idsAsJsonArray) {
        List idsAsIntegers = this.getIdsAsIntegers(idsAsJsonArray);
        String deleteEventsSqlWithPlaceholders = String.format("delete from %s.event_store where id in (%s)", OUTBOX_SCHEMA, this.preparePlaceHolders(idsAsIntegers.size()));
        try (Connection connection = this.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(deleteEventsSqlWithPlaceholders);
            this.setPreparedStatementValues(preparedStatement, idsAsIntegers);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to delete events from the outbox table", (Throwable)e);
        }
    }

    private static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    private List<CamundaTaskEvent> getCreateEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        try (Connection connection = this.getConnection();){
            String sql = String.format("select * from %s.event_store where type = ? fetch first %d rows only", OUTBOX_SCHEMA, maxNumberOfEventsReturned);
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.setString(1, "create");
                ResultSet camundaTaskEventResultSet = preparedStatement.executeQuery();
                camundaTaskEvents = this.getCamundaTaskEvents(camundaTaskEventResultSet);
            }
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught Exception while trying to retrieve create events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private String preparePlaceHolders(int length) {
        return String.join((CharSequence)",", Collections.nCopies(length, "?"));
    }

    private void setPreparedStatementValues(PreparedStatement preparedStatement, List<Integer> ids) throws SQLException {
        for (int i = 0; i < ids.size(); ++i) {
            preparedStatement.setObject(i + 1, ids.get(i));
        }
    }

    private List<CamundaTaskEvent> getCamundaTaskEvents(ResultSet createEventsResultSet) throws SQLException {
        ArrayList<CamundaTaskEvent> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        while (createEventsResultSet.next()) {
            CamundaTaskEvent camundaTaskEvent = new CamundaTaskEvent();
            camundaTaskEvent.setId(createEventsResultSet.getInt(1));
            camundaTaskEvent.setType(createEventsResultSet.getString(2));
            camundaTaskEvent.setCreated(this.formatDate((Date)createEventsResultSet.getTimestamp(3)));
            camundaTaskEvent.setPayload(createEventsResultSet.getString(4));
            camundaTaskEvents.add(camundaTaskEvent);
        }
        return camundaTaskEvents;
    }

    private List<Integer> getIdsAsIntegers(String idsAsJsonArray) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Integer> idsAsIntegers = new ArrayList<Integer>();
        try {
            JsonNode idsAsJsonArrayNode = objectMapper.readTree(idsAsJsonArray).get("taskCreationIds");
            if (idsAsJsonArrayNode != null) {
                idsAsJsonArrayNode.forEach(id -> idsAsIntegers.add(id.asInt()));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Caught IOException while trying to read the passed JSON-Object in the POST-Request to delete events from the outbox table", (Throwable)e);
        }
        return idsAsIntegers;
    }

    private List<CamundaTaskEvent> getCompleteAndDeleteEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        String sql = String.format("select * from %s.event_store where type = ? OR type = ? fetch first %d rows only", OUTBOX_SCHEMA, maxNumberOfEventsReturned);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, "complete");
            preparedStatement.setString(2, "delete");
            ResultSet completeAndDeleteEventsResultSet = preparedStatement.executeQuery();
            camundaTaskEvents = this.getCamundaTaskEvents(completeAndDeleteEventsResultSet);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve complete/delete events from the outbox", (Object)e.getClass().getName());
        }
        return camundaTaskEvents;
    }

    private Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve a connection from the provided datasource", (Object)e.getClass().getName());
        }
        if (connection == null) {
            LOGGER.warn("Retrieved connection was NULL, Please make sure to provide a valid datasource.");
            throw new SystemException("Retrieved connection was NULL. Please make sure to provide a valid datasource.");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() {
        Class<CamundaTaskEventsService> clazz = CamundaTaskEventsService.class;
        synchronized (CamundaTaskEventsService.class) {
            if (this.dataSource == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.getDataSourceFromPropertiesFile();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataSource;
        }
    }

    private DataSource getDataSourceFromPropertiesFile() {
        try {
            Properties properties = CamundaTaskEventsService.getProperties();
            String jndiUrl = properties.getProperty("taskana.adapter.outbox.datasource.jndi");
            this.dataSource = jndiUrl != null ? (DataSource)new InitialContext().lookup(jndiUrl) : CamundaTaskEventsService.createDatasource((String)properties.getProperty("taskana.adapter.outbox.datasource.driver"), (String)properties.getProperty("taskana.adapter.outbox.datasource.url"), (String)properties.getProperty("taskana.adapter.outbox.datasource.username"), (String)properties.getProperty("taskana.adapter.outbox.datasource.password"));
        }
        catch (IOException | NullPointerException | NamingException e) {
            LOGGER.warn("Caught {} while trying to retrieve the datasource from the provided properties file", (Object)e.getClass().getName());
        }
        return this.dataSource;
    }

    private static Properties getProperties() throws IOException {
        if (outboxProperties == null) {
            InputStream propertiesInputStream = CamundaTaskEventsService.class.getClassLoader().getResourceAsStream("taskana-outbox.properties");
            outboxProperties = new Properties();
            outboxProperties.load(propertiesInputStream);
        }
        return outboxProperties;
    }

    private static String getSchemaFromProperties() {
        String defaultSchema = "taskana_tables";
        InputStream propertiesStream = CamundaTaskEventsService.class.getClassLoader().getResourceAsStream("taskana-outbox.properties");
        Properties properties = new Properties();
        String outboxSchema = null;
        try {
            properties.load(propertiesStream);
            outboxSchema = properties.getProperty("taskana.adapter.outbox.schema");
        }
        catch (IOException | NullPointerException e) {
            LOGGER.warn("Caught Exception {} while trying to retrieve the outbox-schema from the provided properties file.", (Object)e.getClass().getName());
        }
        outboxSchema = outboxSchema == null || outboxSchema.isEmpty() ? defaultSchema : outboxSchema;
        return outboxSchema;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault()).format(date.toInstant());
    }

    static {
        maxNumberOfEventsReturned = 0;
        try {
            Properties properties = CamundaTaskEventsService.getProperties();
            if (maxNumberOfEventsReturned == 0) {
                String maxNumberOfEventsString = properties.getProperty("taskana.adapter.outbox.max.number.of.events");
                maxNumberOfEventsReturned = maxNumberOfEventsString != null && !maxNumberOfEventsString.isEmpty() ? Integer.parseInt(maxNumberOfEventsString) : 50;
            }
        }
        catch (IOException | NumberFormatException e) {
            if (maxNumberOfEventsReturned == 0) {
                maxNumberOfEventsReturned = 50;
            }
            LOGGER.warn("attempted to retrieve max number of events to be returned and caught ", (Throwable)e);
        }
        LOGGER.info("Outbox Rest Api will return at max {} events per request", (Object)maxNumberOfEventsReturned);
    }
}

