/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.outbox.rest.controller;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import pro.taskana.adapter.camunda.outbox.rest.controller.PATCH;
import pro.taskana.adapter.camunda.outbox.rest.exception.CamundaTaskEventNotFoundException;
import pro.taskana.adapter.camunda.outbox.rest.exception.InvalidArgumentException;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEvent;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEventList;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventListResource;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventListResourceAssembler;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventResource;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventResourceAssembler;
import pro.taskana.adapter.camunda.outbox.rest.service.CamundaTaskEventsService;

@Path(value="/events")
public class CamundaTaskEventsController {
    CamundaTaskEventsService camundaTaskEventService = new CamundaTaskEventsService();
    CamundaTaskEventResourceAssembler camundaTaskEventResourceAssembler = new CamundaTaskEventResourceAssembler();
    CamundaTaskEventListResourceAssembler camundaTaskEventListResourceAssembler = new CamundaTaskEventListResourceAssembler();

    @GET
    @Produces(value={"application/json"})
    public Response getEvents(@Context UriInfo uriInfo) throws InvalidArgumentException {
        CamundaTaskEventList camundaTaskEventList = new CamundaTaskEventList();
        MultivaluedMap filterParams = uriInfo.getQueryParameters();
        List camundaTaskEvents = this.camundaTaskEventService.getEvents(filterParams);
        camundaTaskEventList.setCamundaTaskEvents(camundaTaskEvents);
        CamundaTaskEventListResource camundaTaskEventListResource = this.camundaTaskEventListResourceAssembler.toResource(camundaTaskEventList);
        return Response.status((int)200).entity((Object)camundaTaskEventListResource).build();
    }

    @Path(value="/{eventId}")
    @GET
    @Produces(value={"application/json"})
    public Response getEvent(@PathParam(value="eventId") int eventId) throws CamundaTaskEventNotFoundException {
        CamundaTaskEvent camundaTaskEvent = this.camundaTaskEventService.getEvent(eventId);
        CamundaTaskEventResource camundaTaskEventResource = this.camundaTaskEventResourceAssembler.toResource(camundaTaskEvent);
        return Response.status((int)200).entity((Object)camundaTaskEventResource).build();
    }

    @Path(value="/delete-successful-events")
    @POST
    @Consumes(value={"application/json"})
    public Response deleteEvents(String idsAsString) {
        this.camundaTaskEventService.deleteEvents(idsAsString);
        return Response.status((int)204).build();
    }

    @Path(value="/{eventId}/decrease-remaining-retries")
    @POST
    @Consumes(value={"application/json"})
    public Response decreaseRemainingRetriesAndLogError(String eventIdOfTaskFailedToStartAndErrorLog) {
        this.camundaTaskEventService.decreaseRemainingRetriesAndLogError(eventIdOfTaskFailedToStartAndErrorLog);
        return Response.status((int)204).build();
    }

    @Path(value="/{eventId}")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setRemainingRetries(@PathParam(value="eventId") int eventId, Map<String, Integer> newRemainingRetries) throws InvalidArgumentException, CamundaTaskEventNotFoundException {
        if (newRemainingRetries == null || !newRemainingRetries.containsKey("remainingRetries")) {
            throw new InvalidArgumentException("Please provide a valid json body in the format {\"remainingRetries\":3}");
        }
        int retriesToSet = newRemainingRetries.get("remainingRetries");
        CamundaTaskEvent camundaTaskEvent = this.camundaTaskEventService.setRemainingRetries(eventId, retriesToSet);
        CamundaTaskEventResource camundaTaskEventResource = this.camundaTaskEventResourceAssembler.toResource(camundaTaskEvent);
        return Response.status((int)200).entity((Object)camundaTaskEventResource).build();
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setRemainingRetriesForMultipleEvents(@QueryParam(value="retries") String retries, Map<String, Integer> newRemainingRetries) throws InvalidArgumentException {
        if (retries == null || retries.isEmpty()) {
            throw new InvalidArgumentException("Please provide a valid \"retries\" query parameter");
        }
        if (newRemainingRetries == null || !newRemainingRetries.containsKey("remainingRetries")) {
            throw new InvalidArgumentException("Please provide a valid json body in the format {\"remainingRetries\":3}");
        }
        int retriesToSet = newRemainingRetries.get("remainingRetries");
        int remainingRetries = Integer.parseInt(retries);
        List camundaTaskEvents = this.camundaTaskEventService.setRemainingRetriesForMultipleEvents(remainingRetries, retriesToSet);
        CamundaTaskEventList camundaTaskEventList = new CamundaTaskEventList();
        camundaTaskEventList.setCamundaTaskEvents(camundaTaskEvents);
        CamundaTaskEventListResource camundaTaskEventListResource = this.camundaTaskEventListResourceAssembler.toResource(camundaTaskEventList);
        return Response.status((int)200).entity((Object)camundaTaskEventListResource).build();
    }

    @Path(value="/{eventId}")
    @DELETE
    public Response deleteFailedEvent(@PathParam(value="eventId") int eventId) {
        this.camundaTaskEventService.deleteFailedEvent(eventId);
        return Response.status((int)204).build();
    }

    @Path(value="/delete-failed-events")
    @POST
    @Consumes(value={"application/json"})
    public Response deleteAllFailedEvents() {
        this.camundaTaskEventService.deleteAllFailedEvents();
        return Response.status((int)204).build();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Response getEventsCount(@QueryParam(value="retries") int remainingRetries) {
        String failedEventsCount = this.camundaTaskEventService.getEventsCount(remainingRetries);
        return Response.status((int)200).entity((Object)failedEventsCount).build();
    }
}

