/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.outbox.rest.controller;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import pro.taskana.adapter.camunda.outbox.rest.exception.CamundaTaskEventNotFoundException;
import pro.taskana.adapter.camunda.outbox.rest.exception.InvalidArgumentException;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEvent;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEventList;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventListResource;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventListResourceAssembler;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventResource;
import pro.taskana.adapter.camunda.outbox.rest.resource.CamundaTaskEventResourceAssembler;
import pro.taskana.adapter.camunda.outbox.rest.service.CamundaTaskEventsService;
import spinjar.com.fasterxml.jackson.core.JsonProcessingException;
import spinjar.com.fasterxml.jackson.core.type.TypeReference;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;

@Path(value="/events")
public class CamundaTaskEventsController {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    CamundaTaskEventsService camundaTaskEventService = new CamundaTaskEventsService();
    CamundaTaskEventResourceAssembler camundaTaskEventResourceAssembler = new CamundaTaskEventResourceAssembler();
    CamundaTaskEventListResourceAssembler camundaTaskEventListResourceAssembler = new CamundaTaskEventListResourceAssembler();

    @GET
    @Produces(value={"application/json"})
    public Response getEvents(@Context UriInfo uriInfo) throws InvalidArgumentException {
        CamundaTaskEventList camundaTaskEventList = new CamundaTaskEventList();
        MultivaluedMap filterParams = uriInfo.getQueryParameters();
        List camundaTaskEvents = this.camundaTaskEventService.getEvents(filterParams);
        camundaTaskEventList.setCamundaTaskEvents(camundaTaskEvents);
        CamundaTaskEventListResource camundaTaskEventListResource = this.camundaTaskEventListResourceAssembler.toResource(camundaTaskEventList);
        return Response.status((int)200).entity((Object)camundaTaskEventListResource).build();
    }

    @Path(value="/{eventId}")
    @GET
    @Produces(value={"application/json"})
    public Response getEvent(@PathParam(value="eventId") int eventId) throws CamundaTaskEventNotFoundException {
        CamundaTaskEvent camundaTaskEvent = this.camundaTaskEventService.getEvent(eventId);
        CamundaTaskEventResource camundaTaskEventResource = this.camundaTaskEventResourceAssembler.toResource(camundaTaskEvent);
        return Response.status((int)200).entity((Object)camundaTaskEventResource).build();
    }

    @Path(value="/delete-successful-events")
    @POST
    @Consumes(value={"application/json"})
    public Response deleteEvents(String idsAsString) {
        this.camundaTaskEventService.deleteEvents(idsAsString);
        return Response.status((int)204).build();
    }

    @Path(value="/{eventId}/decrease-remaining-retries")
    @POST
    @Consumes(value={"application/json"})
    public Response decreaseRemainingRetriesAndLogError(String eventIdOfTaskFailedToStartAndErrorLog) {
        this.camundaTaskEventService.decreaseRemainingRetriesAndLogError(eventIdOfTaskFailedToStartAndErrorLog);
        return Response.status((int)204).build();
    }

    @Path(value="/unlock-event/{eventId}")
    @POST
    @Consumes(value={"application/json"})
    public Response unlockEvent(@PathParam(value="eventId") int eventId) {
        this.camundaTaskEventService.unlockEventForId(Integer.valueOf(eventId));
        return Response.status((int)204).build();
    }

    @Path(value="/{eventId}")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setRemainingRetries(@PathParam(value="eventId") int eventId, String body) throws InvalidArgumentException, CamundaTaskEventNotFoundException, JsonProcessingException {
        Map patchMap = (Map)OBJECT_MAPPER.readValue(body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (patchMap == null || !patchMap.containsKey("remainingRetries")) {
            throw new InvalidArgumentException("Please provide a valid json body in the format {\"remainingRetries\":3}");
        }
        int retriesToSet = (Integer)patchMap.get("remainingRetries");
        CamundaTaskEvent camundaTaskEvent = this.camundaTaskEventService.setRemainingRetries(eventId, retriesToSet);
        CamundaTaskEventResource camundaTaskEventResource = this.camundaTaskEventResourceAssembler.toResource(camundaTaskEvent);
        return Response.status((int)200).entity((Object)camundaTaskEventResource).build();
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setRemainingRetriesForMultipleEvents(@QueryParam(value="retries") String retries, String body) throws InvalidArgumentException, JsonProcessingException {
        if (retries == null || retries.isEmpty()) {
            throw new InvalidArgumentException("Please provide a valid \"retries\" query parameter");
        }
        Map patchMap = (Map)OBJECT_MAPPER.readValue(body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (patchMap == null || !patchMap.containsKey("remainingRetries")) {
            throw new InvalidArgumentException("Please provide a valid json body in the format {\"remainingRetries\":3}");
        }
        int retriesToSet = (Integer)patchMap.get("remainingRetries");
        int remainingRetries = Integer.parseInt(retries);
        List camundaTaskEvents = this.camundaTaskEventService.setRemainingRetriesForMultipleEvents(remainingRetries, retriesToSet);
        CamundaTaskEventList camundaTaskEventList = new CamundaTaskEventList();
        camundaTaskEventList.setCamundaTaskEvents(camundaTaskEvents);
        CamundaTaskEventListResource camundaTaskEventListResource = this.camundaTaskEventListResourceAssembler.toResource(camundaTaskEventList);
        return Response.status((int)200).entity((Object)camundaTaskEventListResource).build();
    }

    @Path(value="/{eventId}")
    @DELETE
    public Response deleteFailedEvent(@PathParam(value="eventId") int eventId) {
        this.camundaTaskEventService.deleteFailedEvent(eventId);
        return Response.status((int)204).build();
    }

    @Path(value="/delete-failed-events")
    @POST
    @Consumes(value={"application/json"})
    public Response deleteAllFailedEvents() {
        this.camundaTaskEventService.deleteAllFailedEvents();
        return Response.status((int)204).build();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Response getEventsCount(@QueryParam(value="retries") int remainingRetries) {
        String failedEventsCount = this.camundaTaskEventService.getEventsCount(remainingRetries);
        return Response.status((int)200).entity((Object)failedEventsCount).build();
    }
}

