/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sample.taskrouting;

import java.security.SecureRandom;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;
import pro.taskana.workbasket.api.models.WorkbasketSummary;

public class ExampleTaskRoutingProviderForAdapterTest
implements TaskRoutingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleTaskRoutingProviderForAdapterTest.class);
    TaskanaEngine theEngine;
    @Value(value="${taskana.sample.taskrouter.random:false}")
    private String routeRandomly;

    public void initialize(TaskanaEngine taskanaEngine) {
        this.theEngine = taskanaEngine;
    }

    public String determineWorkbasketId(Task task) {
        if (this.routeRandomly != null && "true".equalsIgnoreCase(this.routeRandomly)) {
            return this.determineRandomWorkbasket();
        }
        return "WBI:100000000000000000000000000000000001";
    }

    private String determineRandomWorkbasket() {
        List wbs = this.theEngine.getWorkbasketService().createWorkbasketQuery().list();
        if (wbs != null && !wbs.isEmpty()) {
            SecureRandom random = new SecureRandom();
            int n = random.nextInt(wbs.size());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("ExampleTaskRoutingProvider Routs to %s", wbs.get(n)));
            }
            return ((WorkbasketSummary)wbs.get(n)).getId();
        }
        return null;
    }
}

