/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.taskanaconnector.config;

import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;
import pro.taskana.SpringTaskanaEngineConfiguration;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.task.api.TaskService;
import pro.taskana.workbasket.api.WorkbasketService;

@Configuration
@DependsOn(value={"adapterSpringContextProvider"})
public class TaskanaSystemConnectorConfiguration {
    @Value(value="${taskana.schemaName:TASKANA}")
    public String taskanaSchemaName;
    @Value(value="${taskana.datasource.jndi-name:no-jndi-configured}")
    private String jndiName;

    @Bean(name={"taskanaDataSource"})
    @ConfigurationProperties(prefix="taskana.datasource")
    public DataSource taskanaDataSource() throws NamingException {
        if ("no-jndi-configured".equals(this.jndiName)) {
            return DataSourceBuilder.create().build();
        }
        InitialContext ctx = new InitialContext();
        return (DataSource)ctx.lookup(this.jndiName);
    }

    @Bean
    public TaskService getTaskService(TaskanaEngine taskanaEngine) {
        return taskanaEngine.getTaskService();
    }

    @Bean
    public WorkbasketService getWorkbasketService(TaskanaEngine taskanaEngine) {
        return taskanaEngine.getWorkbasketService();
    }

    @Bean
    public ClassificationService getClassificationService(TaskanaEngine taskanaEngine) {
        return taskanaEngine.getClassificationService();
    }

    @Bean
    @Scope(value="singleton")
    public TaskanaEngine taskanaEngine(TaskanaEngineConfiguration taskanaEngineConfiguration) throws SQLException {
        return taskanaEngineConfiguration.buildTaskanaEngine();
    }

    @Bean
    @Scope(value="singleton")
    public SpringTaskanaEngineConfiguration taskanaEngineConfiguration(@Qualifier(value="taskanaDataSource") DataSource taskanaDataSource) {
        return new SpringTaskanaEngineConfiguration(taskanaDataSource, true, true, this.taskanaSchemaName);
    }
}

