/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;
import pro.taskana.adapter.configuration.SchedulerConfiguration;
import pro.taskana.adapter.impl.ReferencedTaskClaimCanceler;
import pro.taskana.adapter.impl.ReferencedTaskClaimer;
import pro.taskana.adapter.impl.ReferencedTaskCompleter;
import pro.taskana.adapter.impl.TaskanaTaskStarter;
import pro.taskana.adapter.impl.TaskanaTaskTerminator;
import pro.taskana.adapter.manager.AdapterManager;

@EnableScheduling
@Import(value={SchedulerConfiguration.class})
@Configuration
public class AdapterConfiguration {
    @Value(value="${.jndi-name:no-jndi-configured}")
    private String jndiName;

    @Bean
    @Scope(value="singleton")
    public AdapterManager manager() {
        return new AdapterManager();
    }

    @Bean
    @Scope(value="singleton")
    public ReferencedTaskCompleter referencedTaskCompleter() {
        return new ReferencedTaskCompleter();
    }

    @Bean
    @Scope(value="singleton")
    public ReferencedTaskClaimer referencedTaskClaimer() {
        return new ReferencedTaskClaimer();
    }

    @Bean
    @Scope(value="singleton")
    public ReferencedTaskClaimCanceler referencedTaskClaimCanceler() {
        return new ReferencedTaskClaimCanceler();
    }

    @Bean
    @Scope(value="singleton")
    public TaskanaTaskStarter taskanaTaskStarter() {
        return new TaskanaTaskStarter();
    }

    @Bean
    @Scope(value="singleton")
    TaskanaTaskTerminator taskanaTaskTerminator() {
        return new TaskanaTaskTerminator();
    }
}

