/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.manager.AdapterManager;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.task.api.CallbackState;

@Component
public class ReferencedTaskClaimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencedTaskClaimer.class);
    @Autowired
    AdapterManager adapterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${taskana.adapter.scheduler.run.interval.for.claimed.referenced.tasks.in.milliseconds}")
    public void retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTasks() {
        Class<ReferencedTaskClaimer> clazz = ReferencedTaskClaimer.class;
        synchronized (ReferencedTaskClaimer.class) {
            if (!this.adapterManager.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LOGGER.debug("--retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTasks started-----------");
            try {
                this.retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTask();
            }
            catch (Exception ex) {
                LOGGER.debug("Caught {} while trying to claim referenced tasks", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTask() {
        LOGGER.trace("ReferencedTaskClaimer.retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTask ENTRY");
        try {
            TaskanaConnector taskanaSystemConnector = this.adapterManager.getTaskanaConnector();
            List<ReferencedTask> tasksClaimedByTaskana = taskanaSystemConnector.retrieveClaimedTaskanaTasksAsReferencedTasks();
            List<ReferencedTask> tasksClaimedInExternalSystem = this.claimReferencedTasksInExternalSystem(tasksClaimedByTaskana);
            taskanaSystemConnector.changeTaskCallbackState(tasksClaimedInExternalSystem, CallbackState.CLAIMED);
        }
        finally {
            LOGGER.trace("ReferencedTaskClaimer.retrieveClaimedTaskanaTasksAndClaimCorrespondingReferencedTask EXIT ");
        }
    }

    private List<ReferencedTask> claimReferencedTasksInExternalSystem(List<ReferencedTask> tasksClaimedByTaskana) {
        ArrayList<ReferencedTask> tasksClaimedInExternalSystem = new ArrayList<ReferencedTask>();
        for (ReferencedTask referencedTask : tasksClaimedByTaskana) {
            if (!this.claimReferencedTask(referencedTask)) continue;
            tasksClaimedInExternalSystem.add(referencedTask);
        }
        return tasksClaimedInExternalSystem;
    }

    private boolean claimReferencedTask(ReferencedTask referencedTask) {
        LOGGER.trace("ENTRY to ReferencedTaskClaimer.claimReferencedTask, TaskId = {} ", (Object)referencedTask.getId());
        boolean success = false;
        try {
            SystemConnector connector = this.adapterManager.getSystemConnectors().get(referencedTask.getSystemUrl());
            if (connector == null) {
                throw new SystemException("couldnt find a connector for systemUrl " + referencedTask.getSystemUrl());
            }
            connector.claimReferencedTask(referencedTask);
            success = true;
        }
        catch (Exception ex) {
            LOGGER.error("Caught {} when attempting to claim referenced task {}", (Object)ex, (Object)referencedTask);
        }
        LOGGER.trace("Exit from ReferencedTaskClaimer.claimReferencedTask, Success = {} ", (Object)success);
        return success;
    }
}

