/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.manager.AdapterManager;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.task.api.CallbackState;

@Component
public class ReferencedTaskCompleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencedTaskCompleter.class);
    @Autowired
    AdapterManager adapterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${taskana.adapter.scheduler.run.interval.for.complete.referenced.tasks.in.milliseconds}")
    public void retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTasks() {
        Class<ReferencedTaskCompleter> clazz = ReferencedTaskCompleter.class;
        synchronized (ReferencedTaskCompleter.class) {
            if (!this.adapterManager.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LOGGER.debug("--retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTasks started-------");
            try {
                this.retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTask();
            }
            catch (Exception ex) {
                LOGGER.debug("Caught exception while trying to complete referenced tasks", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTask() {
        LOGGER.trace("ReferencedTaskCompleter.retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTask ENTRY");
        try {
            TaskanaConnector taskanaSystemConnector = this.adapterManager.getTaskanaConnector();
            List<ReferencedTask> tasksCompletedByTaskana = taskanaSystemConnector.retrieveCompletedTaskanaTasksAsReferencedTasks();
            List<ReferencedTask> tasksCompletedInExternalSystem = this.completeReferencedTasksInExternalSystem(tasksCompletedByTaskana);
            taskanaSystemConnector.changeTaskCallbackState(tasksCompletedInExternalSystem, CallbackState.CALLBACK_PROCESSING_COMPLETED);
        }
        finally {
            LOGGER.trace("ReferencedTaskCompleter.retrieveFinishedTaskanaTasksAndCompleteCorrespondingReferencedTask EXIT ");
        }
    }

    public boolean completeReferencedTask(ReferencedTask referencedTask) {
        LOGGER.trace("ENTRY to ReferencedTaskCompleter.completeReferencedTask, TaskId = {} ", (Object)referencedTask.getId());
        boolean success = false;
        try {
            SystemConnector connector = this.adapterManager.getSystemConnectors().get(referencedTask.getSystemUrl());
            if (connector == null) {
                throw new SystemException("couldnt find a connector for systemUrl " + referencedTask.getSystemUrl());
            }
            connector.completeReferencedTask(referencedTask);
            success = true;
        }
        catch (Exception ex) {
            LOGGER.error("Caught exception when attempting to complete referenced task {}", (Object)referencedTask, (Object)ex);
        }
        LOGGER.trace("Exit from ReferencedTaskCompleter.completeReferencedTask, Success = {} ", (Object)success);
        return success;
    }

    private List<ReferencedTask> completeReferencedTasksInExternalSystem(List<ReferencedTask> tasksCompletedByTaskana) {
        ArrayList<ReferencedTask> tasksCompletedInExternalSystem = new ArrayList<ReferencedTask>();
        for (ReferencedTask referencedTask : tasksCompletedByTaskana) {
            if (!this.completeReferencedTask(referencedTask)) continue;
            tasksCompletedInExternalSystem.add(referencedTask);
        }
        return tasksCompletedInExternalSystem;
    }
}

