/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.exceptions.TaskTerminationFailedException;
import pro.taskana.adapter.manager.AdapterManager;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;

@Component
public class TaskanaTaskTerminator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaTaskTerminator.class);
    @Autowired
    AdapterManager adapterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${taskana.adapter.scheduler.run.interval.for.check.finished.referenced.tasks.in.milliseconds:5000}")
    public void retrieveFinishedReferencedTasksAndTerminateCorrespondingTaskanaTasks() {
        Class clazz = AdapterManager.class;
        synchronized (AdapterManager.class) {
            if (!this.adapterManager.isInitialized()) {
                this.adapterManager.init();
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            clazz = TaskanaTaskTerminator.class;
            synchronized (TaskanaTaskTerminator.class) {
                if (!this.adapterManager.isInitialized()) {
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    return;
                }
                LOGGER.debug("--retrieveFinishedReferencedTasksAndTerminateCorrespondingTaskanaTasks started-----");
                try {
                    for (SystemConnector systemConnector : this.adapterManager.getSystemConnectors().values()) {
                        this.retrieveFinishededReferencedTasksAndTerminateCorrespondingTaskanaTasks(systemConnector);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("caught exception while trying to retrieve finished referenced tasks and terminate corresponding taskana tasks", (Throwable)e);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveFinishededReferencedTasksAndTerminateCorrespondingTaskanaTasks(SystemConnector systemConnector) {
        LOGGER.trace("TaskanaTaskTerminator.retrieveFinishedReferencedTasksAndTerminateCorrespondingTaskanaTasks ENTRY ");
        ArrayList<ReferencedTask> tasksSuccessfullyTerminatedInTaskana = new ArrayList<ReferencedTask>();
        try {
            List<ReferencedTask> taskanaTasksToTerminate = systemConnector.retrieveFinishedReferencedTasks();
            for (ReferencedTask referencedTask : taskanaTasksToTerminate) {
                try {
                    this.terminateTaskanaTask(referencedTask);
                    tasksSuccessfullyTerminatedInTaskana.add(referencedTask);
                }
                catch (TaskTerminationFailedException ex) {
                    LOGGER.error("attempted to terminate task with external Id {} and caught exception", (Object)referencedTask.getId(), (Object)ex);
                }
            }
            systemConnector.taskanaTasksHaveBeenTerminatedForFinishedReferencedTasks(taskanaTasksToTerminate);
        }
        finally {
            LOGGER.trace("TaskanaTaskTerminator.retrieveFinishedReferencedTasksAndTerminateCorrespondingTaskanaTasks EXIT ");
        }
    }

    private void terminateTaskanaTask(ReferencedTask referencedTask) throws TaskTerminationFailedException {
        LOGGER.trace("TaskanaTaskTerminator.terminateTaskanaTask ENTRY ");
        TaskanaConnector taskanaConnector = this.adapterManager.getTaskanaConnector();
        taskanaConnector.terminateTaskanaTask(referencedTask);
        LOGGER.trace("TaskanaTaskTerminator.terminateTaskanaTask EXIT ");
    }
}

