/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.exceptions.ReferencedTaskDoesNotExistInExternalSystemException;
import pro.taskana.adapter.exceptions.TaskCreationFailedException;
import pro.taskana.adapter.impl.UserContext;
import pro.taskana.adapter.manager.AdapterManager;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.models.Task;

@Component
public class TaskanaTaskStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaTaskStarter.class);
    @Value(value="${taskana.adapter.run-as.user}")
    protected String runAsUser;
    @Autowired
    AdapterManager adapterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${taskana.adapter.scheduler.run.interval.for.start.taskana.tasks.in.milliseconds:5000}")
    public void retrieveNewReferencedTasksAndCreateCorrespondingTaskanaTasks() {
        if (!this.adapterIsInitialized()) {
            return;
        }
        Class<TaskanaTaskStarter> clazz = TaskanaTaskStarter.class;
        synchronized (TaskanaTaskStarter.class) {
            if (!this.adapterManager.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LOGGER.debug("-retrieveNewReferencedTasksAndCreateCorrespondingTaskanaTasks started---------------");
            try {
                UserContext.runAsUser(this.runAsUser, () -> {
                    this.retrieveReferencedTasksAndCreateCorrespondingTaskanaTasks();
                    return null;
                });
            }
            catch (Exception ex) {
                LOGGER.error("Caught exception while trying to create Taskana tasks from referenced tasks", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveReferencedTasksAndCreateCorrespondingTaskanaTasks() {
        LOGGER.trace("TaskanaTaskStarter.retrieveReferencedTasksAndCreateCorrespondingTaskanaTasks ENTRY ");
        for (SystemConnector systemConnector : this.adapterManager.getSystemConnectors().values()) {
            try {
                List<ReferencedTask> tasksToStart = systemConnector.retrieveNewStartedReferencedTasks();
                List<ReferencedTask> newCreatedTasksInTaskana = this.createAndStartTaskanaTasks(systemConnector, tasksToStart);
                systemConnector.taskanaTasksHaveBeenCreatedForNewReferencedTasks(newCreatedTasksInTaskana);
            }
            catch (Throwable throwable) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("TaskanaTaskStarter.retrieveReferencedTasksAndCreateCorrespondingTaskanaTasks Leaving handling of new tasks for System Connector %s", systemConnector.getSystemUrl()));
                }
                throw throwable;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace(String.format("TaskanaTaskStarter.retrieveReferencedTasksAndCreateCorrespondingTaskanaTasks Leaving handling of new tasks for System Connector %s", systemConnector.getSystemUrl()));
        }
    }

    public void createTaskanaTask(ReferencedTask referencedTask, TaskanaConnector connector, SystemConnector systemConnector) throws TaskCreationFailedException {
        LOGGER.trace("TaskanaTaskStarter.createTaskanaTask ENTRY ");
        referencedTask.setSystemUrl(systemConnector.getSystemUrl());
        try {
            this.addVariablesToReferencedTask(referencedTask, systemConnector);
            Task taskanaTask = connector.convertToTaskanaTask(referencedTask);
            connector.createTaskanaTask(taskanaTask);
        }
        catch (ReferencedTaskDoesNotExistInExternalSystemException e) {
            LOGGER.warn("While attempting to retrieve variables for task {} caught ", (Object)referencedTask.getId(), (Object)e);
        }
        LOGGER.trace("TaskanaTaskStarter.createTaskanaTask EXIT ");
    }

    private List<ReferencedTask> createAndStartTaskanaTasks(SystemConnector systemConnector, List<ReferencedTask> tasksToStart) {
        ArrayList<ReferencedTask> newCreatedTasksInTaskana = new ArrayList<ReferencedTask>();
        for (ReferencedTask referencedTask : tasksToStart) {
            try {
                this.createTaskanaTask(referencedTask, this.adapterManager.getTaskanaConnector(), systemConnector);
                newCreatedTasksInTaskana.add(referencedTask);
            }
            catch (TaskCreationFailedException e) {
                if (e.getCause() instanceof TaskAlreadyExistException) {
                    newCreatedTasksInTaskana.add(referencedTask);
                    continue;
                }
                LOGGER.warn("caught Exception when attempting to start TaskanaTask for referencedTask {}", (Object)referencedTask, (Object)e);
            }
            catch (Exception e) {
                LOGGER.warn("caught Exception when attempting to start TaskanaTask for referencedTask {}", (Object)referencedTask, (Object)e);
            }
        }
        return newCreatedTasksInTaskana;
    }

    private void addVariablesToReferencedTask(ReferencedTask referencedTask, SystemConnector connector) {
        if (referencedTask.getVariables() == null) {
            String variables = connector.retrieveReferencedTaskVariables(referencedTask.getId());
            referencedTask.setVariables(variables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean adapterIsInitialized() {
        Class<AdapterManager> clazz = AdapterManager.class;
        synchronized (AdapterManager.class) {
            if (!this.adapterManager.isInitialized()) {
                this.adapterManager.init();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }
}

