/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.systemconnector.spi.SystemConnectorProvider;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.adapter.taskanaconnector.spi.TaskanaConnectorProvider;
import pro.taskana.adapter.util.Assert;

@Component
public class AdapterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterManager.class);
    private boolean isInitialized = false;
    private Map<String, SystemConnector> systemConnectors;
    private List<TaskanaConnector> taskanaConnectors;

    public Map<String, SystemConnector> getSystemConnectors() {
        return this.systemConnectors;
    }

    public TaskanaConnector getTaskanaConnector() {
        Assert.assertion(this.taskanaConnectors.size() == 1, "taskanaConnectors.size() == 1");
        return this.taskanaConnectors.get(0);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void init() {
        if (this.isInitialized) {
            return;
        }
        LOGGER.debug("initAdapterInfrastructure called ");
        this.initTaskanaConnectors();
        this.initSystemConnectors();
        this.isInitialized = true;
    }

    private void initSystemConnectors() {
        this.systemConnectors = new HashMap<String, SystemConnector>();
        LOGGER.info("initializing system connectors ");
        ServiceLoader<SystemConnectorProvider> loader = ServiceLoader.load(SystemConnectorProvider.class);
        for (SystemConnectorProvider provider : loader) {
            List<SystemConnector> connectors = provider.create();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("initialized system connectors {} ", connectors);
            }
            for (SystemConnector conn : connectors) {
                this.systemConnectors.put(conn.getSystemUrl(), conn);
            }
        }
    }

    private void initTaskanaConnectors() {
        this.taskanaConnectors = new ArrayList<TaskanaConnector>();
        ServiceLoader<TaskanaConnectorProvider> loader = ServiceLoader.load(TaskanaConnectorProvider.class);
        for (TaskanaConnectorProvider provider : loader) {
            List<TaskanaConnector> connectors = provider.create();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("initialized taskana connectors {} ", connectors);
            }
            this.taskanaConnectors.addAll(connectors);
        }
    }
}

