package pro.taskana.adapter.exceptions;

import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.util.MapCreator;

/** This exception is thrown when the adapter failed to terminate a task in taskana. */
public class TaskTerminationFailedException extends TaskanaException {

  public static final String ERROR_KEY = "TASK_TERMINATION_FAILED";
  private final String taskId;

  public TaskTerminationFailedException(String taskId, Throwable cause) {
    super(
        String.format("Task termination failed for task with id '%s'", taskId),
        ErrorCode.of(ERROR_KEY, MapCreator.of("taskId", taskId)),
        cause);
    this.taskId = taskId;
  }

  public String getTaskId() {
    return taskId;
  }
}
