/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.exceptions;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.TaskanaException;

public class TaskCreationFailedException
extends TaskanaException {
    public static final String ERROR_KEY = "TASK_CREATION_FAILED";
    private final String externalId;

    public TaskCreationFailedException(String externalId, Throwable cause) {
        super(String.format("Error when creating a TASKANA task with externalId '%s'", externalId), ErrorCode.of((String)ERROR_KEY, TaskCreationFailedException.createUnmodifiableMap("task", (Serializable)((Object)externalId))), cause);
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    private static Map<String, Serializable> createUnmodifiableMap(String key, Serializable value) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(key, TaskCreationFailedException.ensureNullIsHandled((Serializable)value));
        return Collections.unmodifiableMap(map);
    }
}

