/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.exceptions;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.TaskanaException;

public class TaskTerminationFailedException
extends TaskanaException {
    public static final String ERROR_KEY = "TASK_TERMINATION_FAILED";
    private final String taskId;

    public TaskTerminationFailedException(String taskId, Throwable cause) {
        super(String.format("Task termination failed for task with id '%s'", taskId), ErrorCode.of((String)ERROR_KEY, TaskTerminationFailedException.createUnmodifiableMap("taskId", (Serializable)((Object)taskId))), cause);
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    private static Map<String, Serializable> createUnmodifiableMap(String key, Serializable value) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(key, TaskTerminationFailedException.ensureNullIsHandled((Serializable)value));
        return Collections.unmodifiableMap(map);
    }
}

