/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import pro.taskana.adapter.impl.UserContext;
import pro.taskana.adapter.manager.AdapterManager;
import pro.taskana.adapter.systemconnector.api.ReferencedTask;
import pro.taskana.adapter.systemconnector.api.SystemConnector;
import pro.taskana.adapter.taskanaconnector.api.TaskanaConnector;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.task.api.CallbackState;

@Component
public class ReferencedTaskClaimCanceler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencedTaskClaimCanceler.class);
    @Value(value="${taskana.adapter.run-as.user}")
    protected String runAsUser;
    @Autowired
    AdapterManager adapterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRateString="${taskana.adapter.scheduler.run.interval.for.cancel.claim.referenced.tasks.in.milliseconds:5000}")
    @Transactional
    public void retrieveCancelledClaimTaskanaTasksAndCancelClaimCorrespondingReferencedTasks() {
        Class<ReferencedTaskClaimCanceler> clazz = ReferencedTaskClaimCanceler.class;
        synchronized (ReferencedTaskClaimCanceler.class) {
            if (!this.adapterManager.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LOGGER.debug("----retrieveCancelledClaimTaskanaTasksAndCancelCorrespondingReferencedTasks started--");
            try {
                UserContext.runAsUser(this.runAsUser, () -> {
                    this.retrieveCancelledClaimTaskanaTasksAndCancelClaimCorrespondingReferencedTask();
                    return null;
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Caught exception while trying to cancel claim referenced tasks", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveCancelledClaimTaskanaTasksAndCancelClaimCorrespondingReferencedTask() {
        try {
            TaskanaConnector taskanaSystemConnector = this.adapterManager.getTaskanaConnector();
            List<ReferencedTask> tasksCancelClaimedByTaskana = taskanaSystemConnector.retrieveCancelledClaimTaskanaTasksAsReferencedTasks();
            List<ReferencedTask> tasksCancelClaimedInExternalSystem = this.cancelClaimReferencedTasksInExternalSystem(tasksCancelClaimedByTaskana);
            taskanaSystemConnector.changeTaskCallbackState(tasksCancelClaimedInExternalSystem, CallbackState.CALLBACK_PROCESSING_REQUIRED);
        }
        finally {
            LOGGER.trace("ReferencedTaskClaimer.retrieveCancelledClaimTaskanaTasksAndCancelClaimCorrespondingReferencedTask EXIT ");
        }
    }

    private List<ReferencedTask> cancelClaimReferencedTasksInExternalSystem(List<ReferencedTask> tasksUnclaimedByTaskana) {
        ArrayList<ReferencedTask> tasksCancelClaimedInExternalSystem = new ArrayList<ReferencedTask>();
        for (ReferencedTask referencedTaskToCancelClaim : tasksUnclaimedByTaskana) {
            if (!this.cancelClaimReferencedTask(referencedTaskToCancelClaim)) continue;
            tasksCancelClaimedInExternalSystem.add(referencedTaskToCancelClaim);
        }
        return tasksCancelClaimedInExternalSystem;
    }

    private boolean cancelClaimReferencedTask(ReferencedTask referencedTask) {
        LOGGER.trace("ENTRY to ReferencedTaskClaimer.cancelClaimReferencedTask, TaskId = {} ", (Object)referencedTask.getId());
        boolean success = false;
        try {
            SystemConnector connector = this.adapterManager.getSystemConnectors().get(referencedTask.getSystemUrl());
            if (connector == null) {
                throw new SystemException("couldnt find a connector for systemUrl " + referencedTask.getSystemUrl());
            }
            connector.cancelClaimReferencedTask(referencedTask);
            success = true;
        }
        catch (Exception ex) {
            LOGGER.error("Caught {} when attempting to cancel the claim for a referenced task {}", (Object)ex, (Object)referencedTask);
        }
        LOGGER.trace("Exit from ReferencedTaskClaimerCanceller.cancelClaimReferencedTask, Success = {} ", (Object)success);
        return success;
    }
}

