/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class WildFlySwarmManifest {
    public static final String CLASSPATH_LOCATION = "META-INF/wildfly-swarm-manifest.yaml";
    private static final String ASSET = "asset";
    private static final String MAIN_CLASS = "main-class";
    private static final String HOLLOW = "hollow";
    private static final String PROPERTIES = "properties";
    private static final String MODULES = "modules";
    private static final String BOOTSTRAP_ARTIFACTS = "bootstrap-artifacts";
    private static final String BUNDLE_DEPENDENCIES = "bundle-dependencies";
    private static final String DEPENDENCIES = "dependencies";
    private String asset = null;
    private Set<String> bootstrapModules = new LinkedHashSet<String>();
    private Set<String> bootstrapArtifacts = new LinkedHashSet<String>();
    private Set<String> dependencies = new HashSet<String>();
    private Properties properties = new Properties();
    private Boolean bundleDependencies;
    private String mainClass = "org.wildfly.swarm.Swarm";
    private boolean hollow;

    public WildFlySwarmManifest() {
    }

    public WildFlySwarmManifest(URL url) throws IOException {
        this.read(url);
    }

    public WildFlySwarmManifest(InputStream in) throws IOException {
        this.read(in);
    }

    public void read(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.read(in);
        }
    }

    public void read(InputStream in) throws IOException {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(in);
        this.asset = (String)data.get(ASSET);
        this.mainClass = (String)data.get(MAIN_CLASS);
        this.hollow = (Boolean)data.get(HOLLOW);
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)((Map)data.get(PROPERTIES)));
        this.bootstrapModules.clear();
        this.bootstrapModules.addAll((Collection)data.get(MODULES));
        this.bootstrapArtifacts.clear();
        this.bootstrapArtifacts.addAll((Collection)data.get(BOOTSTRAP_ARTIFACTS));
        if (data.get(BUNDLE_DEPENDENCIES) != null) {
            this.bundleDependencies = (boolean)((Boolean)data.get(BUNDLE_DEPENDENCIES));
        }
        this.dependencies.clear();
        this.dependencies.addAll((Collection)data.get(DEPENDENCIES));
        this.setupProperties();
    }

    public void write(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (FileWriter out = new FileWriter(path.toFile());){
            out.write(this.toString());
        }
    }

    public String toString() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(){
            {
                if (WildFlySwarmManifest.this.asset != null) {
                    this.put(WildFlySwarmManifest.ASSET, WildFlySwarmManifest.this.asset);
                }
                this.put(WildFlySwarmManifest.MAIN_CLASS, WildFlySwarmManifest.this.mainClass);
                this.put(WildFlySwarmManifest.HOLLOW, WildFlySwarmManifest.this.hollow);
                this.put(WildFlySwarmManifest.PROPERTIES, WildFlySwarmManifest.this.properties);
                this.put(WildFlySwarmManifest.MODULES, WildFlySwarmManifest.this.bootstrapModules);
                this.put(WildFlySwarmManifest.BOOTSTRAP_ARTIFACTS, WildFlySwarmManifest.this.bootstrapArtifacts);
                this.put(WildFlySwarmManifest.BUNDLE_DEPENDENCIES, WildFlySwarmManifest.this.bundleDependencies);
                this.put(WildFlySwarmManifest.DEPENDENCIES, WildFlySwarmManifest.this.dependencies);
            }
        };
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        return yaml.dump(data);
    }

    private void setupProperties() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.properties.get(name);
            if (value == null || System.getProperty(name) != null) continue;
            System.setProperty(name, value.toString());
        }
        if (this.bundleDependencies != null && this.bundleDependencies.booleanValue()) {
            System.setProperty("thorntail.bundled.dependencies", this.bundleDependencies.toString());
        }
    }

    public void addBootstrapModule(String module) {
        this.bootstrapModules.add(module);
    }

    public Set<String> bootstrapModules() {
        return this.bootstrapModules;
    }

    public void addBootstrapArtifact(String artifact) {
        this.bootstrapArtifacts.add(artifact);
    }

    public Set<String> bootstrapArtifacts() {
        return this.bootstrapArtifacts;
    }

    public void addDependency(String gav) {
        this.dependencies.add(gav);
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setAsset(String asset) {
        if (!this.isHollow()) {
            this.asset = asset;
        }
    }

    public String getAsset() {
        return this.asset;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void bundleDependencies(boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
    }

    public boolean isBundleDependencies() {
        if (this.bundleDependencies == null) {
            return true;
        }
        return this.bundleDependencies;
    }

    public void setMainClass(String mainClass) {
        if (mainClass != null) {
            this.mainClass = mainClass;
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
        if (this.isHollow()) {
            this.asset = null;
        }
    }

    public boolean isHollow() {
        return this.hollow;
    }
}

