/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.task.api.TaskService;
import pro.taskana.workbasket.api.WorkbasketService;

@ApplicationScoped
public class TaskanaProducers {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaProducers.class);
    private static final String TASKANA_PROPERTIES = "taskana.properties";
    @Inject
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineConfiguration taskanaEngineConfiguration;

    @PostConstruct
    public void init() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (InputStream propertyStream = classloader.getResourceAsStream(TASKANA_PROPERTIES);){
            Properties properties = new Properties();
            InitialContext ctx = new InitialContext();
            properties.load(propertyStream);
            DataSource dataSource = (DataSource)ctx.lookup(properties.getProperty("datasource.jndi"));
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                LOGGER.debug("---------------> {}", (Object)metaData);
            }
            this.taskanaEngineConfiguration = new TaskanaEngineConfiguration(dataSource, true, false, "TASKANA");
        }
        catch (IOException | SQLException | NamingException e) {
            LOGGER.error("Could not start Taskana: ", (Throwable)e);
        }
    }

    @ApplicationScoped
    @Produces
    public TaskanaEngine generateTaskEngine() throws SQLException {
        return this.taskanaEngineConfiguration.buildTaskanaEngine();
    }

    @ApplicationScoped
    @Produces
    public TaskService generateTaskService() {
        return this.taskanaEngine.getTaskService();
    }

    @ApplicationScoped
    @Produces
    public ClassificationService generateClassificationService() {
        return this.taskanaEngine.getClassificationService();
    }

    @ApplicationScoped
    @Produces
    public WorkbasketService generateWorkbasketService() {
        return this.taskanaEngine.getWorkbasketService();
    }
}

