/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaConfiguration;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.internal.TaskanaCdiStartupException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.task.api.TaskService;
import pro.taskana.workbasket.api.WorkbasketService;

@ApplicationScoped
public class TaskanaProducers {
    private static final Logger LOGGER;
    private static final String TASKANA_PROPERTIES = "taskana.properties";
    private TaskanaConfiguration taskanaConfiguration;
    private final TaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        TaskanaProducers.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaProducers.class);
    }

    public TaskanaProducers() {
        this.taskanaEngine = null;
    }

    @Inject
    public TaskanaProducers(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
    }

    private void forceEagerInitialization(@Observes Startup startup) {
        Startup startup2 = startup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)startup2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("startup={}", (Object)startup);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @PostConstruct
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream propertyStream = classloader.getResourceAsStream(TASKANA_PROPERTIES);){
                Properties properties = new Properties();
                InitialContext ctx = new InitialContext();
                properties.load(propertyStream);
                DataSource dataSource = (DataSource)ctx.lookup(properties.getProperty("datasource.jndi"));
                if (LOGGER.isDebugEnabled()) {
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try (Connection connection = dataSource.getConnection();){
                        DatabaseMetaData metaData = connection.getMetaData();
                        LOGGER.debug("---------------> {}", (Object)metaData);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                this.taskanaConfiguration = new TaskanaConfiguration.Builder(dataSource, true, "TASKANA", false).initTaskanaProperties().build();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | SQLException | NamingException e) {
            throw new TaskanaCdiStartupException(e);
        }
        Object var13_18 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_18);
    }

    @ApplicationScoped
    @Produces
    public TaskanaEngine generateTaskEngine() throws SQLException {
        TaskanaEngine taskanaEngine;
        TaskanaEngine taskanaEngine2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskanaEngine taskanaEngine3 = taskanaEngine2 = (taskanaEngine = TaskanaEngine.buildTaskanaEngine((TaskanaConfiguration)this.taskanaConfiguration));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskanaEngine2);
        return taskanaEngine;
    }

    @ApplicationScoped
    @Produces
    public TaskService generateTaskService() {
        TaskService taskService;
        TaskService taskService2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskService taskService3 = taskService2 = (taskService = this.taskanaEngine.getTaskService());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskService2);
        return taskService;
    }

    @ApplicationScoped
    @Produces
    public ClassificationService generateClassificationService() {
        ClassificationService classificationService;
        ClassificationService classificationService2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationService classificationService3 = classificationService2 = (classificationService = this.taskanaEngine.getClassificationService());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationService2);
        return classificationService;
    }

    @ApplicationScoped
    @Produces
    public WorkbasketService generateWorkbasketService() {
        WorkbasketService workbasketService;
        WorkbasketService workbasketService2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketService workbasketService3 = workbasketService2 = (workbasketService = this.taskanaEngine.getWorkbasketService());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketService2);
        return workbasketService;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaProducers.java", TaskanaProducers.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "forceEagerInitialization", "pro.taskana.common.internal.TaskanaProducers", "jakarta.enterprise.event.Startup", "startup", "", "void"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "pro.taskana.common.internal.TaskanaProducers", "", "", "", "void"), 61);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateTaskEngine", "pro.taskana.common.internal.TaskanaProducers", "", "", "java.sql.SQLException", "pro.taskana.common.api.TaskanaEngine"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateTaskService", "pro.taskana.common.internal.TaskanaProducers", "", "", "", "pro.taskana.task.api.TaskService"), 95);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateClassificationService", "pro.taskana.common.internal.TaskanaProducers", "", "", "", "pro.taskana.classification.api.ClassificationService"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateWorkbasketService", "pro.taskana.common.internal.TaskanaProducers", "", "", "", "pro.taskana.workbasket.api.WorkbasketService"), 107);
    }
}

