/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sampledata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.sampledata.SampleDataProvider;
import pro.taskana.sampledata.SqlReplacer;

public class SampleDataGenerator {
    private static final Logger LOGGER;
    private static final String CACHED_TEST = "TEST";
    private static final String CACHED_SAMPLE = "SAMPLE";
    private static final String CACHED_MONITOR = "MONITOR";
    private static final String CACHED_CLEAR_DB = "CLEARDB";
    private static final String CACHED_DROP_DB = "DROP_DB";
    private static final HashMap<String, List<String>> CACHED_SCRIPTS;
    private final DataSource dataSource;
    private final ZonedDateTime now;
    private final String schema;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        SampleDataGenerator.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SampleDataGenerator.class);
        CACHED_SCRIPTS = new HashMap();
    }

    public SampleDataGenerator(DataSource dataSource, String schema) {
        this(dataSource, schema, Instant.now().atZone(ZoneId.of("UTC")));
    }

    public SampleDataGenerator(DataSource dataSource, String schema, ZonedDateTime now) {
        this.dataSource = dataSource;
        this.schema = schema;
        this.now = now;
    }

    public void generateSampleData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.clearDb();
        Stream<String> scripts = SampleDataProvider.getSampleDataCreationScripts();
        this.executeAndCacheScripts(scripts, CACHED_SAMPLE);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    public void generateTestData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Stream<String> scripts = SampleDataProvider.getTestDataScripts();
        this.executeAndCacheScripts(scripts, CACHED_TEST);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    public void generateMonitorData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Stream<String> scripts = SampleDataProvider.getMonitorDataScripts();
        this.executeAndCacheScripts(scripts, CACHED_MONITOR);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    public void clearDb() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Stream<String> scripts = SampleDataProvider.getScriptsToClearDatabase();
        this.executeAndCacheScripts(scripts, CACHED_CLEAR_DB);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    public void dropDb() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Stream<String> scripts = SampleDataProvider.getScriptsToDropDatabase();
        this.executeAndCacheScripts(scripts, CACHED_DROP_DB);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    /*
     * Unable to fully structure code
     */
    private List<String> parseScripts(Stream<String> scripts) {
        var7_2 = scripts;
        var6_3 = Factory.makeJP((JoinPoint.StaticPart)SampleDataGenerator.ajc$tjp_5, (Object)this, (Object)this, var7_2);
        LoggingAspect.aspectOf().beforeMethodExecuted(var6_3);
        var2_4 = null;
        var3_7 = null;
        connection = this.dataSource.getConnection();
        try {
            dbProductId = DB.getDatabaseProductId((Connection)connection);
            v0 = scripts.map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((SampleDataGenerator)this, (String)dbProductId)).collect(Collectors.toList());
            ** if (connection == null) goto lbl-1000
        }
        catch (Throwable var2_5) {
            try {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    throw var2_5;
                }
                catch (Throwable var3_8) {
                    if (var2_4 == null) {
                        var2_4 = var3_8;
                    } else if (var2_4 != var3_8) {
                        var2_4.addSuppressed(var3_8);
                    }
                    throw var2_4;
                }
            }
            catch (SQLException e) {
                throw new RuntimeSqlException("Connection to database failed.", (Throwable)e);
            }
        }
lbl-1000:
        // 1 sources

        {
            connection.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        var8_11 = v0;
        v1 = var9_12 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var6_3, var9_12);
        return var8_11;
    }

    private void runScripts(Consumer<ScriptRunner> consumer) {
        Consumer<ScriptRunner> consumer2 = consumer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, consumer2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (Connection connection = this.dataSource.getConnection();){
                String trimmedErrorString;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Generating sample data for database of type '{}' with url '{}' and schema '{}'.", new Object[]{DB.getDatabaseProductName((Connection)connection), connection.getMetaData().getURL(), this.schema});
                }
                StringWriter outWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                ScriptRunner runner = this.getScriptRunner(connection, outWriter, errorWriter);
                consumer.accept(runner);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(outWriter.toString());
                }
                if (LOGGER.isErrorEnabled() && !(trimmedErrorString = errorWriter.toString().trim()).isEmpty()) {
                    LOGGER.error(trimmedErrorString);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Failed to execute script.", (Throwable)e);
        }
        Object var11_14 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_14);
    }

    private void executeAndCacheScripts(Stream<String> scripts, String cacheKey) {
        Stream<String> stream = scripts;
        String string = cacheKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, stream, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.runScripts(runner -> CACHED_SCRIPTS.computeIfAbsent(cacheKey, key -> this.parseScripts(scripts)).stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).map(ByteArrayInputStream::new).map(s -> new InputStreamReader((InputStream)s, StandardCharsets.UTF_8)).forEach(arg_0 -> ((ScriptRunner)runner).runScript(arg_0)));
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private ScriptRunner getScriptRunner(Connection connection, StringWriter outWriter, StringWriter errorWriter) throws SQLException {
        ScriptRunner scriptRunner;
        ScriptRunner scriptRunner2;
        Connection connection2 = connection;
        StringWriter stringWriter = outWriter;
        StringWriter stringWriter2 = errorWriter;
        Object[] objectArray = new Object[]{connection2, stringWriter, stringWriter2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PrintWriter logWriter = new PrintWriter(outWriter);
        PrintWriter errorLogWriter = new PrintWriter(errorWriter);
        ScriptRunner runner = new ScriptRunner(connection);
        connection.setSchema(this.schema);
        runner.setLogWriter(logWriter);
        runner.setErrorLogWriter(errorLogWriter);
        runner.setStopOnError(true);
        ScriptRunner scriptRunner3 = scriptRunner2 = (scriptRunner = runner);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scriptRunner2);
        return scriptRunner;
    }

    private /* synthetic */ String lambda$0(String string, String script) {
        return SqlReplacer.getScriptAsSql(string, this.now, script);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SampleDataGenerator.java", SampleDataGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateSampleData", "pro.taskana.sampledata.SampleDataGenerator", "", "", "", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateTestData", "pro.taskana.sampledata.SampleDataGenerator", "", "", "", "void"), 59);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateMonitorData", "pro.taskana.sampledata.SampleDataGenerator", "", "", "", "void"), 64);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearDb", "pro.taskana.sampledata.SampleDataGenerator", "", "", "", "void"), 69);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dropDb", "pro.taskana.sampledata.SampleDataGenerator", "", "", "", "void"), 74);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parseScripts", "pro.taskana.sampledata.SampleDataGenerator", "java.util.stream.Stream", "scripts", "", "java.util.List"), 79);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runScripts", "pro.taskana.sampledata.SampleDataGenerator", "java.util.function.Consumer", "consumer", "", "void"), 90);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "executeAndCacheScripts", "pro.taskana.sampledata.SampleDataGenerator", "java.util.stream.Stream:java.lang.String", "scripts:cacheKey", "", "void"), 120);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getScriptRunner", "pro.taskana.sampledata.SampleDataGenerator", "java.sql.Connection:java.io.StringWriter:java.io.StringWriter", "connection:outWriter:errorWriter", "java.sql.SQLException", "org.apache.ibatis.jdbc.ScriptRunner"), 130);
    }
}

