/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.sampledata;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.sampledata.SampleDataGenerator;

final class SqlReplacer {
    static final String RELATIVE_DATE_REGEX = "RELATIVE_DATE\\((-?\\d+)\\)";
    static final Pattern RELATIVE_DATE_PATTERN;
    static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        SqlReplacer.ajc$preClinit();
        RELATIVE_DATE_PATTERN = Pattern.compile(RELATIVE_DATE_REGEX);
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    }

    private SqlReplacer() {
    }

    static String getScriptAsSql(String dbProductId, ZonedDateTime now, String scriptPath) {
        String string;
        String string2;
        String string3 = dbProductId;
        ZonedDateTime zonedDateTime = now;
        String string4 = scriptPath;
        Object[] objectArray = new Object[]{string3, zonedDateTime, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string5 = string2 = (string = SqlReplacer.parseAndReplace(SqlReplacer.getScriptBufferedStream(scriptPath), now, dbProductId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static String replaceDatePlaceholder(ZonedDateTime now, String sql) {
        String string;
        String string2;
        ZonedDateTime zonedDateTime = now;
        String string3 = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)zonedDateTime, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Matcher m = RELATIVE_DATE_PATTERN.matcher(sql);
        StringBuffer sb = new StringBuffer(sql.length());
        while (m.find()) {
            long daysToShift = Long.parseLong(m.group(1));
            String daysAsStringDate = SqlReplacer.formatToSqlDate(now, daysToShift);
            m.appendReplacement(sb, daysAsStringDate);
        }
        m.appendTail(sb);
        String string4 = string2 = (string = sb.toString());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static BufferedReader getScriptBufferedStream(String script) {
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2;
        String string = script;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BufferedReader bufferedReader3 = bufferedReader2 = (bufferedReader = (BufferedReader)Optional.ofNullable(SampleDataGenerator.class.getResourceAsStream(script)).map(inputStream -> new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8))).orElse(null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bufferedReader2);
        return bufferedReader;
    }

    private static String replaceBooleanWithInteger(String sql) {
        String string;
        String string2;
        String string3 = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string4 = string2 = (string = sql.replaceAll("(?i)true", "1").replaceAll("(?i)false", "0"));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String replaceEmptyStringWithPlaceholder(String sql) {
        String string;
        String string2;
        String string3 = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string4 = string2 = (string = sql.replace("''", String.format("'%s'", "#EMPTY#")));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String parseAndReplace(BufferedReader bufferedReader, ZonedDateTime now, String dbProductId) {
        String string;
        String string2;
        BufferedReader bufferedReader2 = bufferedReader;
        ZonedDateTime zonedDateTime = now;
        String string3 = dbProductId;
        Object[] objectArray = new Object[]{bufferedReader2, zonedDateTime, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String sql = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
        if (DB.isDb2((String)dbProductId) || DB.isOracle((String)dbProductId)) {
            sql = SqlReplacer.replaceBooleanWithInteger(sql);
        }
        if (DB.isOracle((String)dbProductId)) {
            sql = SqlReplacer.replaceEmptyStringWithPlaceholder(sql);
            sql = "ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF3';\n" + sql;
        }
        String string4 = string2 = (string = SqlReplacer.replaceDatePlaceholder(now, sql));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static String formatToSqlDate(ZonedDateTime now, long days) {
        String string;
        String string2;
        ZonedDateTime zonedDateTime = now;
        long l = days;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)zonedDateTime, (Object)Conversions.longObject((long)l));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = "'" + now.plusDays(days).format(DATE_TIME_FORMATTER) + "'");
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SqlReplacer.java", SqlReplacer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "getScriptAsSql", "pro.taskana.sampledata.SqlReplacer", "java.lang.String:java.time.ZonedDateTime:java.lang.String", "dbProductId:now:scriptPath", "", "java.lang.String"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "replaceDatePlaceholder", "pro.taskana.sampledata.SqlReplacer", "java.time.ZonedDateTime:java.lang.String", "now:sql", "", "java.lang.String"), 45);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "getScriptBufferedStream", "pro.taskana.sampledata.SqlReplacer", "java.lang.String", "script", "", "java.io.BufferedReader"), 57);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "replaceBooleanWithInteger", "pro.taskana.sampledata.SqlReplacer", "java.lang.String", "sql", "", "java.lang.String"), 65);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "replaceEmptyStringWithPlaceholder", "pro.taskana.sampledata.SqlReplacer", "java.lang.String", "sql", "", "java.lang.String"), 69);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "parseAndReplace", "pro.taskana.sampledata.SqlReplacer", "java.io.BufferedReader:java.time.ZonedDateTime:java.lang.String", "bufferedReader:now:dbProductId", "", "java.lang.String"), 73);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "formatToSqlDate", "pro.taskana.sampledata.SqlReplacer", "java.time.ZonedDateTime:long", "now:days", "", "java.lang.String"), 87);
    }
}

