/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.internal.logging.NoLogging;

@NoLogging
@Aspect
public class LoggingAspect {
    public static final String ENABLE_LOGGING_ASPECT_PROPERTY_KEY = "enableLoggingAspect";
    private static final Map<String, Logger> CLASS_TO_LOGGER = new ConcurrentHashMap<String, Logger>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LoggingAspect ajc$perSingletonInstance;

    static {
        try {
            LoggingAspect.ajc$perSingletonInstance = new LoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="!@annotation(pro.taskana.common.internal.logging.NoLogging) && !within(@pro.taskana.common.internal.logging.NoLogging *) && execution(* pro.taskana..*(..)) && !execution(* lambda*(..)) && !execution(* access*(..)) && !execution(String *.toString()) && !execution(int *.hashCode()) && !execution(boolean *.canEqual(Object)) && !execution(boolean *.equals(Object))")
    public /* synthetic */ void traceLogging() {
    }

    public static boolean isLoggingAspectEnabled() {
        return LazyHolder.LOGGING_ASPECT_ENABLED;
    }

    @Before(value="traceLogging()")
    public void beforeMethodExecuted(JoinPoint joinPoint) {
        MethodSignature methodSignature;
        String declaringTypeName;
        Logger currentLogger;
        if (LoggingAspect.isLoggingAspectEnabled() && (currentLogger = CLASS_TO_LOGGER.computeIfAbsent(declaringTypeName = (methodSignature = (MethodSignature)joinPoint.getSignature()).getDeclaringTypeName(), LoggerFactory::getLogger)).isTraceEnabled()) {
            String methodName = methodSignature.getName();
            Object[] values = joinPoint.getArgs();
            String[] parameterNames = methodSignature.getParameterNames();
            String parametersValues = LoggingAspect.mapParametersNameValue(parameterNames, values);
            currentLogger.trace("entry to {}({})", (Object)methodName, (Object)parametersValues);
        }
    }

    @AfterReturning(pointcut="traceLogging()", returning="returnedObject")
    public void afterMethodExecuted(JoinPoint joinPoint, Object returnedObject) {
        MethodSignature methodSignature;
        String declaringTypeName;
        Logger currentLogger;
        if (LoggingAspect.isLoggingAspectEnabled() && (currentLogger = CLASS_TO_LOGGER.computeIfAbsent(declaringTypeName = (methodSignature = (MethodSignature)joinPoint.getSignature()).getDeclaringTypeName(), LoggerFactory::getLogger)).isTraceEnabled()) {
            String methodName = methodSignature.getName();
            Class returnType = methodSignature.getReturnType();
            if (returnType.isAssignableFrom(Void.TYPE)) {
                currentLogger.trace("exit from {}.", (Object)methodName);
            } else {
                currentLogger.trace("exit from {}. Returning: '{}'", (Object)methodName, (Object)Objects.toString(returnedObject, "null"));
            }
        }
    }

    private static String mapParametersNameValue(String[] parameterNames, Object[] values) {
        HashMap<String, Object> parametersNameToValue = new HashMap<String, Object>();
        if (parameterNames.length > 0) {
            int i = 0;
            while (i < parameterNames.length) {
                parametersNameToValue.put(parameterNames[i], values[i]);
                ++i;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry parameter : parametersNameToValue.entrySet()) {
            stringBuilder.append((String)parameter.getKey()).append(" = ").append(parameter.getValue());
        }
        return stringBuilder.toString();
    }

    public static LoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("pro.taskana.common.internal.logging.LoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    private static class LazyHolder {
        private static final boolean LOGGING_ASPECT_ENABLED = "true".equals(System.getProperty("enableLoggingAspect"));

        private LazyHolder() {
        }
    }
}

