/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.api.security.GroupPrincipal;
import pro.taskana.common.internal.logging.LoggingAspect;

public class CurrentUserContextImpl
implements CurrentUserContext {
    private static final String GET_UNIQUE_SECURITY_NAME_METHOD = "getUniqueSecurityName";
    private static final String GET_CALLER_SUBJECT_METHOD = "getCallerSubject";
    private static final String WSSUBJECT_CLASSNAME = "com.ibm.websphere.security.auth.WSSubject";
    private static final Logger LOGGER;
    private final boolean shouldUseLowerCaseForAccessIds;
    private boolean runningOnWebSphere;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        CurrentUserContextImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(CurrentUserContextImpl.class);
    }

    public CurrentUserContextImpl(boolean shouldUseLowerCaseForAccessIds) {
        this.shouldUseLowerCaseForAccessIds = shouldUseLowerCaseForAccessIds;
        try {
            Class.forName(WSSUBJECT_CLASSNAME);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("WSSubject detected. Assuming that Taskana runs on IBM WebSphere.");
            }
            this.runningOnWebSphere = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No WSSubject detected. Using JAAS subject further on.");
            }
            this.runningOnWebSphere = false;
        }
    }

    @Override
    public String getUserid() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = this.runningOnWebSphere ? this.getUserIdFromWsSubject() : this.getUserIdFromJaasSubject();
        String string3 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    @Override
    public List<String> getGroupIds() {
        List<String> list;
        List<String> list2;
        List<String> list3;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Subject subject = Subject.getSubject(AccessController.getContext());
        LOGGER.trace("Subject of caller: {}", (Object)subject);
        if (subject != null) {
            Set<GroupPrincipal> groups = subject.getPrincipals(GroupPrincipal.class);
            LOGGER.trace("Public groups of caller: {}", groups);
            list2 = list3 = groups.stream().map(Principal::getName).filter(Objects::nonNull).map(this::convertAccessId).collect(Collectors.toList());
        } else {
            LOGGER.trace("No groupIds found in subject!");
            list2 = list3 = Collections.emptyList();
        }
        List<String> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list3;
    }

    @Override
    public List<String> getAccessIds() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> accessIds = new ArrayList<String>(this.getGroupIds());
        accessIds.add(this.getUserid());
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = accessIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private String getUserIdFromWsSubject() {
        String string;
        String string2;
        String string3;
        JoinPoint joinPoint;
        block5: {
            block4: {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
                try {
                    Class<?> wsSubjectClass = Class.forName(WSSUBJECT_CLASSNAME);
                    Method getCallerSubjectMethod = wsSubjectClass.getMethod(GET_CALLER_SUBJECT_METHOD, null);
                    Subject callerSubject = (Subject)getCallerSubjectMethod.invoke(null, null);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Subject of caller: {}", (Object)callerSubject);
                    }
                    if (callerSubject == null) break block4;
                    Set<Object> publicCredentials = callerSubject.getPublicCredentials();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Public credentials of caller: {}", publicCredentials);
                    }
                    string2 = string3 = (String)publicCredentials.stream().map(credential -> {
                        try {
                            return credential.getClass().getMethod(GET_UNIQUE_SECURITY_NAME_METHOD, null).invoke(credential, null);
                        }
                        catch (Exception e) {
                            throw new SecurityException("Could not retrieve principal", e);
                        }
                    }).peek(o -> LOGGER.debug("Returning the unique security name of first public credential: {}", o)).map(Object::toString).map(this::convertAccessId).findFirst().orElse(null);
                }
                catch (Exception exception) {
                    LOGGER.warn("Could not get user from WSSubject. Going ahead unauthorized.");
                }
                break block5;
            }
            string2 = string3 = null;
        }
        String string4 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, string);
        return string3;
    }

    private String getUserIdFromJaasSubject() {
        String string;
        String string2;
        String string3;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Subject subject = Subject.getSubject(AccessController.getContext());
        LOGGER.trace("Subject of caller: {}", (Object)subject);
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            LOGGER.trace("Public principals of caller: {}", principals);
            string2 = string3 = (String)principals.stream().filter(Predicate.not(GroupPrincipal.class::isInstance)).map(Principal::getName).filter(Objects::nonNull).map(this::convertAccessId).findFirst().orElse(null);
        } else {
            LOGGER.trace("No userId found in subject!");
            string2 = string3 = null;
        }
        String string4 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, string);
        return string3;
    }

    private String convertAccessId(String accessId) {
        String string;
        String string2;
        String string3 = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String toReturn = accessId;
        if (this.shouldUseLowerCaseForAccessIds) {
            toReturn = accessId.toLowerCase();
        }
        LOGGER.trace("Found AccessId '{}'. Returning AccessId '{}' ", (Object)accessId, (Object)toReturn);
        String string4 = string2 = (string = toReturn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CurrentUserContextImpl.java", CurrentUserContextImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserid", "pro.taskana.common.internal.security.CurrentUserContextImpl", "", "", "", "java.lang.String"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupIds", "pro.taskana.common.internal.security.CurrentUserContextImpl", "", "", "", "java.util.List"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessIds", "pro.taskana.common.internal.security.CurrentUserContextImpl", "", "", "", "java.util.List"), 71);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserIdFromWsSubject", "pro.taskana.common.internal.security.CurrentUserContextImpl", "", "", "", "java.lang.String"), 83);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserIdFromJaasSubject", "pro.taskana.common.internal.security.CurrentUserContextImpl", "", "", "", "java.lang.String"), 131);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertAccessId", "pro.taskana.common.internal.security.CurrentUserContextImpl", "java.lang.String", "accessId", "", "java.lang.String"), 150);
    }
}

