/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;

public class DockerContainerCreator {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private DockerContainerCreator() {
        throw new IllegalStateException("Utility class");
    }

    public static Optional<JdbcDatabaseContainer<?>> createDockerContainer(DB db) {
        Optional<JdbcDatabaseContainer<?>> optional;
        Optional<JdbcDatabaseContainer<?>> optional2;
        Optional<JdbcDatabaseContainer<?>> optional3;
        DB dB = db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)dB);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        switch (db) {
            case DB2: {
                optional2 = optional3 = Optional.of(((Db2Container)new Db2Container(DockerImageName.parse((String)"taskana/db2:11.1").asCompatibleSubstituteFor("ibmcom/db2")).waitingFor(new LogMessageWaitStrategy().withRegEx(".*DB2START processing was successful.*").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)))).withUsername("db2inst1").withPassword("db2inst1-pwd").withDatabaseName("TSKDB"));
                break;
            }
            case POSTGRES: {
                optional2 = optional3 = Optional.of((JdbcDatabaseContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres:10")).withUsername("postgres").withPassword("postgres").withDatabaseName("postgres").withCommand(new String[]{"/bin/sh", "-c", "localedef -i de_DE -c -f UTF-8 -A /usr/share/locale/locale.alias de_DE.UTF-8 && export LANG=de_DE.UTF-8 && ./docker-entrypoint.sh postgres -c fsync=off"})).waitingFor(new LogMessageWaitStrategy().withRegEx(".*Datenbanksystem ist bereit, um Verbindungen anzunehmen.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS))));
                break;
            }
            default: {
                optional2 = optional3 = Optional.empty();
            }
        }
        Optional<JdbcDatabaseContainer<?>> optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    public static DataSource createDataSource(JdbcDatabaseContainer<?> container) {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        JdbcDatabaseContainer<?> jdbcDatabaseContainer = container;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, jdbcDatabaseContainer);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), container.getDriverClassName(), container.getJdbcUrl(), container.getUsername(), container.getPassword());
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    static {
        DockerContainerCreator.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DockerContainerCreator.java", DockerContainerCreator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDockerContainer", "pro.taskana.common.test.DockerContainerCreator", "pro.taskana.common.internal.configuration.DB", "db", "", "java.util.Optional"), 23);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDataSource", "pro.taskana.common.test.DockerContainerCreator", "org.testcontainers.containers.JdbcDatabaseContainer", "container", "", "javax.sql.DataSource"), 59);
    }
}

