/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.security;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.security.auth.Subject;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.security.GroupPrincipal;
import pro.taskana.common.api.security.UserPrincipal;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.test.security.WithAccessId;
import pro.taskana.common.test.security.WithAccessIds;

public class JaasExtension
implements InvocationInterceptor,
TestTemplateInvocationContextProvider {
    private static final String ACCESS_IDS_STORE_KEY = "accessIds";

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) {
        return JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        if (AnnotationSupport.isAnnotated((AnnotatedElement)invocationContext.getExecutable(), WithAccessIds.class)) {
            throw new JUnitException("Please use @TestTemplate instead of @Test for multiple accessIds");
        }
        JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        WithAccessIds annotation = ((Method)invocationContext.getExecutable()).getAnnotation(WithAccessIds.class);
        if (annotation != null) {
            Iterable<Object> newChildrenForDynamicContainer;
            Object factoryResult = JaasExtension.performInvocationWithAccessId(invocation, annotation.value()[0]);
            if (factoryResult instanceof DynamicNode) {
                newChildrenForDynamicContainer = Collections.singleton((DynamicNode)factoryResult);
            } else if (factoryResult instanceof Stream) {
                Stream nodes = (Stream)factoryResult;
                newChildrenForDynamicContainer = nodes.collect(Collectors.toList());
            } else if (factoryResult instanceof Iterable) {
                newChildrenForDynamicContainer = (Iterable)factoryResult;
            } else if (factoryResult instanceof Iterator) {
                newChildrenForDynamicContainer = () -> (Iterator)factoryResult;
            } else if (factoryResult instanceof DynamicNode[]) {
                newChildrenForDynamicContainer = Arrays.asList((DynamicNode[])factoryResult);
            } else {
                throw new SystemException(String.format("Testfactory '%s' did not return a proper type", ((Method)invocationContext.getExecutable()).getName()));
            }
            HashMap<String, List<DynamicNode>> childrenMap = new HashMap<String, List<DynamicNode>>();
            JaasExtension.persistDynamicContainerChildren(newChildrenForDynamicContainer, childrenMap);
            Function<WithAccessId, DynamicContainer> wrapTestsInDynamicContainer = accessId -> DynamicContainer.dynamicContainer((String)JaasExtension.getDisplayNameForAccessId(accessId), StreamSupport.stream(newChildrenForDynamicContainer.spliterator(), false).map(x -> JaasExtension.duplicateDynamicNode(x, childrenMap)));
            ExtensionContext.Store store = this.getStore(extensionContext);
            return (T)Stream.of(annotation.value()).peek(a -> store.put((Object)ACCESS_IDS_STORE_KEY, a)).map(wrapTestsInDynamicContainer);
        }
        return JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        WithAccessId accessId = (WithAccessId)this.getStore(extensionContext).get((Object)ACCESS_IDS_STORE_KEY, WithAccessId.class);
        JaasExtension.performInvocationWithAccessId(invocation, accessId);
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) {
        ExtensionContext testContext = this.getParentMethodExtensionContent(extensionContext);
        WithAccessId o = (WithAccessId)this.getStore(testContext).get((Object)ACCESS_IDS_STORE_KEY, WithAccessId.class);
        if (o != null) {
            JaasExtension.performInvocationWithAccessId(invocation, o);
        } else {
            JaasExtension.extractAccessIdAndPerformInvocation(invocation, testContext.getRequiredTestMethod());
        }
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        JaasExtension.extractAccessIdAndPerformInvocation(invocation, invocationContext.getExecutable());
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationSupport.isAnnotated((Optional)context.getElement(), WithAccessIds.class) || AnnotationSupport.isAnnotated((Optional)context.getElement(), WithAccessId.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        List accessIds = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), WithAccessId.class);
        ExtensionContext.Store store = this.getStore(context);
        return accessIds.stream().peek(a -> store.put((Object)ACCESS_IDS_STORE_KEY, a)).map(x$0 -> new JaasExtensionInvocationContext((WithAccessId)x$0));
    }

    private static void persistDynamicContainerChildren(Iterable<DynamicNode> nodes, Map<String, List<DynamicNode>> childrenMap) {
        nodes.forEach(node -> {
            if (node instanceof DynamicContainer) {
                DynamicContainer container = (DynamicContainer)node;
                List<DynamicNode> children = container.getChildren().collect(Collectors.toList());
                childrenMap.put(container.hashCode() + container.getDisplayName(), children);
                JaasExtension.persistDynamicContainerChildren(children, childrenMap);
            }
        });
    }

    private static DynamicNode duplicateDynamicNode(DynamicNode node, Map<String, List<DynamicNode>> lookupMap) {
        if (node instanceof DynamicContainer) {
            DynamicContainer container = (DynamicContainer)node;
            Stream<DynamicNode> children = lookupMap.get(node.hashCode() + node.getDisplayName()).stream().map(x -> JaasExtension.duplicateDynamicNode(x, lookupMap));
            return DynamicContainer.dynamicContainer((String)container.getDisplayName(), children);
        }
        return node;
    }

    private static <T> T extractAccessIdAndPerformInvocation(InvocationInterceptor.Invocation<T> invocation, AnnotatedElement executable) {
        return JaasExtension.performInvocationWithAccessId(invocation, executable.getAnnotation(WithAccessId.class));
    }

    private static <T> T performInvocationWithAccessId(InvocationInterceptor.Invocation<T> invocation, WithAccessId withAccessId) {
        Subject subject = new Subject();
        subject.getPrincipals().addAll(JaasExtension.getPrincipals(withAccessId));
        Function proceedInvocation = CheckedFunction.wrap(InvocationInterceptor.Invocation::proceed);
        PrivilegedAction<Object> performInvocation = () -> proceedInvocation.apply(invocation);
        return (T)Subject.doAs(subject, performInvocation);
    }

    private static List<Principal> getPrincipals(WithAccessId withAccessId) {
        if (withAccessId != null) {
            return Stream.concat(Stream.of(withAccessId.user()).map(UserPrincipal::new), Arrays.stream(withAccessId.groups()).map(GroupPrincipal::new)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private ExtensionContext getParentMethodExtensionContent(ExtensionContext extensionContext) {
        Optional<Class> parent = extensionContext.getParent();
        while (!parent.map(Object::getClass).map(Class::getName).filter(s -> s.endsWith("MethodExtensionContext")).isPresent()) {
            parent = parent.flatMap(ExtensionContext::getParent);
        }
        return (ExtensionContext)parent.orElseThrow(() -> new JUnitException(String.format("Test '%s' does not have a parent method", extensionContext.getUniqueId())));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }

    private static String getDisplayNameForAccessId(WithAccessId withAccessId) {
        return String.format("for user '%s'", withAccessId.user());
    }

    private static class JaasExtensionInvocationContext
    implements TestTemplateInvocationContext {
        private final WithAccessId withAccessId;

        private JaasExtensionInvocationContext(WithAccessId withAccessId) {
            this.withAccessId = withAccessId;
        }

        public String getDisplayName(int invocationIndex) {
            return JaasExtension.getDisplayNameForAccessId(this.withAccessId);
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new WithAccessIdParameterResolver());
        }

        private class WithAccessIdParameterResolver
        implements ParameterResolver {
            private WithAccessIdParameterResolver() {
            }

            public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                return parameterContext.getParameter().getType().equals(WithAccessId.class);
            }

            public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                return JaasExtensionInvocationContext.this.withAccessId;
            }
        }
    }
}

