/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test;

import capital.scalable.restdocs.AutoDocumentation;
import capital.scalable.restdocs.jackson.JacksonResultHandlers;
import capital.scalable.restdocs.response.ResponseModifyingPreprocessors;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Links;
import org.springframework.lang.NonNull;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.RestDocumentationExtension;
import org.springframework.restdocs.cli.CliDocumentation;
import org.springframework.restdocs.http.HttpDocumentation;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import pro.taskana.common.test.rest.RestHelper;
import pro.taskana.common.test.rest.TaskanaSpringBootTest;

@TaskanaSpringBootTest
@ExtendWith(value={RestDocumentationExtension.class})
public class BaseRestDocTest {
    protected MockMvc mockMvc;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected RestHelper restHelper;
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    @BeforeEach
    public void setUp(WebApplicationContext webApplicationContext, RestDocumentationContextProvider restDocumentation) {
        this.objectMapper = this.objectMapper.addMixIn(Links.class, MixInIgnoreType.class);
        this.mockMvc = ((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)webApplicationContext).apply(SecurityMockMvcConfigurers.springSecurity())).apply((MockMvcConfigurer)this.configureAdminHeadersAsDefault())).alwaysDo(JacksonResultHandlers.prepareJackson((ObjectMapper)this.objectMapper))).alwaysDo((ResultHandler)this.commonDocumentation(new Snippet[0]))).apply((MockMvcConfigurer)MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)restDocumentation).snippets().withDefaults(new Snippet[]{CliDocumentation.curlRequest(), HttpDocumentation.httpRequest(), HttpDocumentation.httpResponse(), AutoDocumentation.requestFields().failOnUndocumentedFields(true), AutoDocumentation.responseFields().failOnUndocumentedFields(true), AutoDocumentation.pathParameters().failOnUndocumentedParams(true), AutoDocumentation.requestParameters().failOnUndocumentedParams(true), AutoDocumentation.description(), AutoDocumentation.methodAndPath(), AutoDocumentation.modelAttribute((Collection)this.requestMappingHandlerAdapter.getArgumentResolvers()), AutoDocumentation.sectionBuilder().snippetNames(new String[]{"auto-authorization", "auto-path-parameters", "auto-request-parameters", "auto-modelattribute", "auto-request-fields", "auto-response-fields", "auto-links", "http-request", "http-response"}).build()}))).build();
    }

    protected RestDocumentationResultHandler commonDocumentation(Snippet ... snippets) {
        return MockMvcRestDocumentation.document((String)"{ClassName}/{methodName}", (OperationRequestPreprocessor)Preprocessors.preprocessRequest((OperationPreprocessor[])new OperationPreprocessor[]{Preprocessors.prettyPrint()}), (OperationResponsePreprocessor)Preprocessors.preprocessResponse((OperationPreprocessor[])new OperationPreprocessor[]{ResponseModifyingPreprocessors.replaceBinaryContent(), ResponseModifyingPreprocessors.limitJsonArrayLength((ObjectMapper)this.objectMapper), Preprocessors.prettyPrint()}), (Snippet[])snippets);
    }

    private MockMvcConfigurerAdapter configureAdminHeadersAsDefault() {
        return new MockMvcConfigurerAdapter(){

            public RequestPostProcessor beforeMockMvcCreated(@NonNull ConfigurableMockMvcBuilder<?> builder, @NonNull WebApplicationContext cxt) {
                builder.defaultRequest((RequestBuilder)MockMvcRequestBuilders.post((String)"/test", (Object[])new Object[0]).headers(BaseRestDocTest.this.restHelper.getHeadersAdmin()));
                return super.beforeMockMvcCreated(builder, cxt);
            }
        };
    }

    @JsonIgnoreType
    public static class MixInIgnoreType {
    }
}

