/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.rest;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import pro.taskana.sampledata.SampleDataGenerator;

@SpringBootApplication
@ComponentScan(value={"pro.taskana"})
@DependsOn(value={"getTaskanaEngine"})
public class TestConfiguration {
    @Autowired
    public TestConfiguration(@Value(value="${taskana.schemaName:TASKANA}") String schemaName, DataSource dataSource) {
        new SampleDataGenerator(dataSource, schemaName).generateSampleData();
    }

    @Bean
    public PlatformTransactionManager txManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

