/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.rest;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class TestWebSecurityConfig {
    private final String ldapServerUrl;
    private final String ldapBaseDn;
    private final String ldapGroupSearchBase;
    private final String ldapGroupSearchFilter;

    @Autowired
    public TestWebSecurityConfig(@Value(value="${taskana.ldap.serverUrl:ldap://localhost:10389}") String ldapServerUrl, @Value(value="${taskana.ldap.baseDn:OU=Test,O=TASKANA}") String ldapBaseDn, @Value(value="${taskana.ldap.groupSearchBase:cn=groups}") String ldapGroupSearchBase, @Value(value="${taskana.ldap.groupSearchFilter:uniqueMember={0}}") String ldapGroupSearchFilter) {
        this.ldapServerUrl = ldapServerUrl;
        this.ldapBaseDn = ldapBaseDn;
        this.ldapGroupSearchBase = ldapGroupSearchBase;
        this.ldapGroupSearchFilter = ldapGroupSearchFilter;
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new CorsWebMvcConfigurer();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }

    @Bean
    public LdapAuthoritiesPopulator authoritiesPopulator(DefaultSpringSecurityContextSource contextSource) {
        Function<Map, GrantedAuthority> authorityMapper = record -> new SimpleGrantedAuthority((String)((List)record.get("spring.security.ldap.dn")).get(0));
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((ContextSource)contextSource, this.ldapGroupSearchBase);
        populator.setGroupSearchFilter(this.ldapGroupSearchFilter);
        populator.setSearchSubtree(true);
        populator.setRolePrefix("");
        populator.setAuthorityMapper(authorityMapper);
        return populator;
    }

    @Bean
    public DefaultSpringSecurityContextSource defaultSpringSecurityContextSource() {
        return new DefaultSpringSecurityContextSource(this.ldapServerUrl + "/" + this.ldapBaseDn);
    }

    @Bean
    public GrantedAuthoritiesMapper grantedAuthoritiesMapper() {
        SimpleAuthorityMapper grantedAuthoritiesMapper = new SimpleAuthorityMapper();
        grantedAuthoritiesMapper.setPrefix("");
        return grantedAuthoritiesMapper;
    }

    private static class CorsWebMvcConfigurer
    implements WebMvcConfigurer {
        private CorsWebMvcConfigurer() {
        }

        public void addCorsMappings(CorsRegistry registry) {
            registry.addMapping("/**").allowedOrigins(new String[]{"*"});
        }
    }
}

