/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskanaEngineTestConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineTestConfiguration.class);
    private static final int POOL_TIME_TO_WAIT = 50;
    private static final DataSource DATA_SOURCE;
    private static String schemaName;

    private TaskanaEngineTestConfiguration() {
    }

    public static DataSource getDataSource() {
        return DATA_SOURCE;
    }

    public static String getSchemaName() {
        if (schemaName == null) {
            String propertiesFileName = System.getProperty("user.home") + "/taskanaUnitTest.properties";
            File f = new File(propertiesFileName);
            schemaName = f.exists() && !f.isDirectory() ? TaskanaEngineTestConfiguration.getSchemaNameFromPropertiesObject(propertiesFileName) : "TASKANA";
        }
        return schemaName;
    }

    public static DataSource createDataSourceFromProperties(String propertiesFileName) {
        DataSource ds;
        try (FileInputStream input = new FileInputStream(propertiesFileName);){
            String dbPassword;
            String dbUserName;
            String jdbcUrl;
            Properties prop = new Properties();
            prop.load(input);
            boolean propertiesFileIsComplete = true;
            String warningMessage = "";
            String jdbcDriver = prop.getProperty("jdbcDriver");
            if (jdbcDriver == null || jdbcDriver.length() == 0) {
                propertiesFileIsComplete = false;
                warningMessage = warningMessage + ", jdbcDriver property missing";
            }
            if ((jdbcUrl = prop.getProperty("jdbcUrl")) == null || jdbcUrl.length() == 0) {
                propertiesFileIsComplete = false;
                warningMessage = warningMessage + ", jdbcUrl property missing";
            }
            if ((dbUserName = prop.getProperty("dbUserName")) == null || dbUserName.length() == 0) {
                propertiesFileIsComplete = false;
                warningMessage = warningMessage + ", dbUserName property missing";
            }
            if ((dbPassword = prop.getProperty("dbPassword")) == null || dbPassword.length() == 0) {
                propertiesFileIsComplete = false;
                warningMessage = warningMessage + ", dbPassword property missing";
            }
            if (propertiesFileIsComplete) {
                ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), jdbcDriver, jdbcUrl, dbUserName, dbPassword);
                ((PooledDataSource)ds).forceCloseAll();
            } else {
                LOGGER.warn("propertiesFile {} is incomplete {}", (Object)propertiesFileName, (Object)warningMessage);
                LOGGER.warn("Using default Datasource for Test");
                ds = TaskanaEngineTestConfiguration.createDefaultDataSource();
            }
        }
        catch (IOException e) {
            LOGGER.warn("createDataSourceFromProperties caught Exception ", (Throwable)e);
            LOGGER.warn("Using default Datasource for Test");
            ds = TaskanaEngineTestConfiguration.createDefaultDataSource();
        }
        return ds;
    }

    static String getSchemaNameFromPropertiesObject(String propertiesFileName) {
        String schemaName = "TASKANA";
        try (FileInputStream input = new FileInputStream(propertiesFileName);){
            Properties prop = new Properties();
            prop.load(input);
            boolean propertiesFileIsComplete = true;
            String warningMessage = "";
            schemaName = prop.getProperty("schemaName");
            if (schemaName == null || schemaName.length() == 0) {
                propertiesFileIsComplete = false;
                warningMessage = warningMessage + ", schemaName property missing";
            }
            if (!propertiesFileIsComplete) {
                LOGGER.warn("propertiesFile {} is incomplete {}", (Object)propertiesFileName, (Object)warningMessage);
                LOGGER.warn("Using default Datasource for Test");
                schemaName = "TASKANA";
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", (Throwable)e);
            LOGGER.warn("Using default schemaName for Test");
        }
        return schemaName;
    }

    private static DataSource createDefaultDataSource() {
        String jdbcDriver = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE ";
        String dbUserName = "sa";
        String dbPassword = "sa";
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), jdbcDriver, jdbcUrl, dbUserName, dbPassword);
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        return ds;
    }

    static {
        schemaName = null;
        String propertiesFileName = System.getProperty("user.home") + "/taskanaUnitTest.properties";
        File f = new File(propertiesFileName);
        DATA_SOURCE = f.exists() && !f.isDirectory() ? TaskanaEngineTestConfiguration.createDataSourceFromProperties(propertiesFileName) : TaskanaEngineTestConfiguration.createDefaultDataSource();
    }
}

