/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.internal.logging.LoggingAspect;

public final class TaskanaEngineTestConfiguration {
    private static final Logger LOGGER;
    private static final int POOL_TIME_TO_WAIT = 50;
    private static final DataSource DATA_SOURCE;
    private static String schemaName;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        TaskanaEngineTestConfiguration.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaEngineTestConfiguration.class);
        schemaName = null;
        String propertiesFileName = String.valueOf(System.getProperty("user.home")) + "/taskanaUnitTest.properties";
        File f = new File(propertiesFileName);
        DATA_SOURCE = f.exists() && !f.isDirectory() ? TaskanaEngineTestConfiguration.createDataSourceFromProperties(propertiesFileName) : TaskanaEngineTestConfiguration.createDefaultDataSource();
    }

    private TaskanaEngineTestConfiguration() {
    }

    public static DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = DATA_SOURCE);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public static String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (schemaName == null) {
            String propertiesFileName = String.valueOf(System.getProperty("user.home")) + "/taskanaUnitTest.properties";
            File f = new File(propertiesFileName);
            schemaName = f.exists() && !f.isDirectory() ? TaskanaEngineTestConfiguration.getSchemaNameFromPropertiesObject(propertiesFileName) : "TASKANA";
        }
        String string3 = string2 = (string = schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static DataSource createDataSourceFromProperties(String propertiesFileName) {
        DataSource dataSource;
        DataSource dataSource2;
        DataSource ds;
        String string = propertiesFileName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream input = new FileInputStream(propertiesFileName);){
                String dbPassword;
                String dbUserName;
                String jdbcUrl;
                Properties prop = new Properties();
                prop.load(input);
                boolean propertiesFileIsComplete = true;
                String warningMessage = "";
                String jdbcDriver = prop.getProperty("jdbcDriver");
                if (jdbcDriver == null || jdbcDriver.length() == 0) {
                    propertiesFileIsComplete = false;
                    warningMessage = String.valueOf(warningMessage) + ", jdbcDriver property missing";
                }
                if ((jdbcUrl = prop.getProperty("jdbcUrl")) == null || jdbcUrl.length() == 0) {
                    propertiesFileIsComplete = false;
                    warningMessage = String.valueOf(warningMessage) + ", jdbcUrl property missing";
                }
                if ((dbUserName = prop.getProperty("dbUserName")) == null || dbUserName.length() == 0) {
                    propertiesFileIsComplete = false;
                    warningMessage = String.valueOf(warningMessage) + ", dbUserName property missing";
                }
                if ((dbPassword = prop.getProperty("dbPassword")) == null || dbPassword.length() == 0) {
                    propertiesFileIsComplete = false;
                    warningMessage = String.valueOf(warningMessage) + ", dbPassword property missing";
                }
                if (propertiesFileIsComplete) {
                    ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), jdbcDriver, jdbcUrl, dbUserName, dbPassword);
                    ((PooledDataSource)ds).forceCloseAll();
                } else {
                    LOGGER.warn("propertiesFile {} is incomplete {}", (Object)propertiesFileName, (Object)warningMessage);
                    LOGGER.warn("Using default Datasource for Test");
                    ds = TaskanaEngineTestConfiguration.createDefaultDataSource();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warn("createDataSourceFromProperties caught Exception ", (Throwable)e);
            LOGGER.warn("Using default Datasource for Test");
            ds = TaskanaEngineTestConfiguration.createDefaultDataSource();
        }
        DataSource dataSource3 = dataSource2 = (dataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    static String getSchemaNameFromPropertiesObject(String propertiesFileName) {
        String string;
        String string2;
        String string3 = propertiesFileName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String schemaName = "TASKANA";
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (FileInputStream input = new FileInputStream(propertiesFileName);){
                Properties prop = new Properties();
                prop.load(input);
                boolean propertiesFileIsComplete = true;
                String warningMessage = "";
                schemaName = prop.getProperty("schemaName");
                if (schemaName == null || schemaName.length() == 0) {
                    propertiesFileIsComplete = false;
                    warningMessage = String.valueOf(warningMessage) + ", schemaName property missing";
                }
                if (!propertiesFileIsComplete) {
                    LOGGER.warn("propertiesFile {} is incomplete {}", (Object)propertiesFileName, (Object)warningMessage);
                    LOGGER.warn("Using default Datasource for Test");
                    schemaName = "TASKANA";
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception ", (Throwable)e);
            LOGGER.warn("Using default schemaName for Test");
        }
        String string4 = string2 = (string = schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static DataSource createDefaultDataSource() {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String jdbcDriver = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE ";
        String dbUserName = "sa";
        String dbPassword = "sa";
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), jdbcDriver, jdbcUrl, dbUserName, dbPassword);
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaEngineTestConfiguration.java", TaskanaEngineTestConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDataSource", "pro.taskana.common.test.config.TaskanaEngineTestConfiguration", "", "", "", "javax.sql.DataSource"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSchemaName", "pro.taskana.common.test.config.TaskanaEngineTestConfiguration", "", "", "", "java.lang.String"), 59);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDataSourceFromProperties", "pro.taskana.common.test.config.TaskanaEngineTestConfiguration", "java.lang.String", "propertiesFileName", "", "javax.sql.DataSource"), 78);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "getSchemaNameFromPropertiesObject", "pro.taskana.common.test.config.TaskanaEngineTestConfiguration", "java.lang.String", "propertiesFileName", "", "java.lang.String"), 131);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "createDefaultDataSource", "pro.taskana.common.test.config.TaskanaEngineTestConfiguration", "", "", "", "javax.sql.DataSource"), 158);
    }
}

