/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;

public class TestContainerExtension
implements AfterAllCallback {
    private final DataSource dataSource;
    private final String schemaName;
    private final JdbcDatabaseContainer<?> container;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public TestContainerExtension() {
        DB db = this.getTestDatabase();
        Optional<JdbcDatabaseContainer<?>> container = TestContainerExtension.createDockerContainer(db);
        if (container.isPresent()) {
            this.container = container.get();
            this.container.start();
            this.dataSource = TestContainerExtension.createDataSource(this.container);
        } else {
            this.dataSource = TestContainerExtension.createDataSourceForH2();
            this.container = null;
        }
        this.schemaName = TestContainerExtension.determineSchemaName(db);
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext extensionContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)extensionContext);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.container != null) {
            this.container.stop();
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private DB getTestDatabase() {
        DB dB;
        DB dB2;
        DB db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String property = System.getenv("db.type");
        try {
            db = DB.valueOf((String)property);
        }
        catch (Exception exception) {
            db = DB.H2;
        }
        DB dB3 = dB2 = (dB = db);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    private static String determineSchemaName(DB db) {
        String string;
        DB dB = db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)dB);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = db == DB.POSTGRES ? "taskana" : "TASKANA";
        String string3 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    private static DataSource createDataSource(JdbcDatabaseContainer<?> container) {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        JdbcDatabaseContainer<?> jdbcDatabaseContainer = container;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, jdbcDatabaseContainer);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), container.getDriverClassName(), container.getJdbcUrl(), container.getUsername(), container.getPassword());
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    private static Optional<JdbcDatabaseContainer<?>> createDockerContainer(DB db) {
        Optional<JdbcDatabaseContainer<?>> optional;
        Optional<JdbcDatabaseContainer<?>> optional2;
        Optional<JdbcDatabaseContainer<?>> optional3;
        DB dB = db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)dB);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        switch (db) {
            case DB2: {
                optional2 = optional3 = Optional.of(((Db2Container)new Db2Container(DockerImageName.parse((String)"taskana/db2:11.1").asCompatibleSubstituteFor("ibmcom/db2")).waitingFor(new LogMessageWaitStrategy().withRegEx(".*DB2START processing was successful.*").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)))).withUsername("db2inst1").withPassword("db2inst1-pwd").withDatabaseName("TSKDB"));
                break;
            }
            case POSTGRES: {
                optional2 = optional3 = Optional.of((JdbcDatabaseContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres:10")).withUsername("postgres").withPassword("postgres").withDatabaseName("postgres").withCommand(new String[]{"/bin/sh", "-c", "localedef -i de_DE -c -f UTF-8 -A /usr/share/locale/locale.alias de_DE.UTF-8 && export LANG=de_DE.UTF-8 && ./docker-entrypoint.sh postgres -c fsync=off"})).waitingFor(new LogMessageWaitStrategy().withRegEx(".*Datenbanksystem ist bereit, um Verbindungen anzunehmen.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS))));
                break;
            }
            default: {
                optional2 = optional3 = Optional.empty();
            }
        }
        Optional<JdbcDatabaseContainer<?>> optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private static DataSource createDataSourceForH2() {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), "org.h2.Driver", "jdbc:h2:mem:" + UUID.randomUUID() + ";LOCK_MODE=0;" + "INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;" + "SET COLLATION DEFAULT_de_DE ", "sa", "sa");
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    static {
        TestContainerExtension.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestContainerExtension.java", TestContainerExtension.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterAll", "pro.taskana.common.test.config.TestContainerExtension", "org.junit.jupiter.api.extension.ExtensionContext", "context", "", "void"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSource", "pro.taskana.common.test.config.TestContainerExtension", "", "", "", "javax.sql.DataSource"), 47);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "pro.taskana.common.test.config.TestContainerExtension", "", "", "", "java.lang.String"), 51);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTestDatabase", "pro.taskana.common.test.config.TestContainerExtension", "", "", "", "pro.taskana.common.internal.configuration.DB"), 55);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "determineSchemaName", "pro.taskana.common.test.config.TestContainerExtension", "pro.taskana.common.internal.configuration.DB", "db", "", "java.lang.String"), 66);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "createDataSource", "pro.taskana.common.test.config.TestContainerExtension", "org.testcontainers.containers.JdbcDatabaseContainer", "container", "", "javax.sql.DataSource"), 70);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "createDockerContainer", "pro.taskana.common.test.config.TestContainerExtension", "pro.taskana.common.internal.configuration.DB", "db", "", "java.util.Optional"), 83);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "createDataSourceForH2", "pro.taskana.common.test.config.TestContainerExtension", "", "", "", "javax.sql.DataSource"), 119);
    }
}

